/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindMap;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQuery;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlQueryContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdate;
import org.openmetadata.service.jdbi3.locator.ConnectionAwareSqlUpdateContainer;
import org.openmetadata.service.jdbi3.locator.ConnectionType;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.jdbi.BindFQN;
import org.openmetadata.service.util.jdbi.BindUUID;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EntityDAO<T extends EntityInterface> {
    public static final Logger LOG = LoggerFactory.getLogger(EntityDAO.class);

    public String getTableName();

    public Class<T> getEntityClass();

    default public String getNameHashColumn() {
        return "nameHash";
    }

    default public boolean supportsSoftDelete() {
        return true;
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="INSERT INTO <table> (<nameHashColumn>, json) VALUES (:nameHashColumnValue, :json)", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="INSERT INTO <table> (<nameHashColumn>, json) VALUES (:nameHashColumnValue, :json :: jsonb)", connectionType=ConnectionType.POSTGRES)})
    public void insert(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @BindFQN(value="nameHashColumnValue") String var3, @Bind(value="json") String var4);

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="UPDATE <table> SET  json = :json, <nameHashColumn> = :nameHashColumnValue WHERE id = :id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="UPDATE <table> SET  json = (:json :: jsonb), <nameHashColumn> = :nameHashColumnValue WHERE id = :id", connectionType=ConnectionType.POSTGRES)})
    public void update(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @BindFQN(value="nameHashColumnValue") String var3, @Bind(value="id") String var4, @Bind(value="json") String var5);

    default public void updateFqn(String oldPrefix, String newPrefix) {
        LOG.info("Updating FQN for {} from {} to {}", new Object[]{this.getTableName(), oldPrefix, newPrefix});
        if (!this.getNameHashColumn().equals("fqnHash")) {
            return;
        }
        String mySqlUpdate = String.format("UPDATE %s SET json = JSON_REPLACE(json, '$.fullyQualifiedName', REGEXP_REPLACE(JSON_UNQUOTE(JSON_EXTRACT(json, '$.fullyQualifiedName')), '^%s\\.', '%s.')) , fqnHash = REPLACE(fqnHash, '%s.', '%s.') WHERE fqnHash LIKE '%s.%%'", this.getTableName(), ListFilter.escape(oldPrefix), ListFilter.escapeApostrophe(newPrefix), FullyQualifiedName.buildHash(oldPrefix), FullyQualifiedName.buildHash(newPrefix), FullyQualifiedName.buildHash(oldPrefix));
        String postgresUpdate = String.format("UPDATE %s SET json = REPLACE(json::text, '\"fullyQualifiedName\": \"%s.', '\"fullyQualifiedName\": \"%s.')::jsonb , fqnHash = REPLACE(fqnHash, '%s.', '%s.') WHERE fqnHash LIKE '%s.%%'", this.getTableName(), ReindexingUtil.escapeDoubleQuotes(ListFilter.escapeApostrophe(oldPrefix)), ReindexingUtil.escapeDoubleQuotes(ListFilter.escapeApostrophe(newPrefix)), FullyQualifiedName.buildHash(oldPrefix), FullyQualifiedName.buildHash(newPrefix), FullyQualifiedName.buildHash(oldPrefix));
        this.updateFqnInternal(mySqlUpdate, postgresUpdate);
    }

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="<mySqlUpdate>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="<postgresUpdate>", connectionType=ConnectionType.POSTGRES)})
    public void updateFqnInternal(@Define(value="mySqlUpdate") String var1, @Define(value="postgresUpdate") String var2);

    @SqlQuery(value="SELECT json FROM <table> WHERE id = :id <cond>")
    public String findById(@Define(value="table") String var1, @BindUUID(value="id") UUID var2, @Define(value="cond") String var3);

    @SqlQuery(value="SELECT json FROM <table> WHERE <nameColumnHash> = :name <cond>")
    public String findByName(@Define(value="table") String var1, @Define(value="nameColumnHash") String var2, @BindFQN(value="name") String var3, @Define(value="cond") String var4);

    @SqlQuery(value="SELECT count(<nameHashColumn>) FROM <table> <cond>")
    public int listCount(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @BindMap Map<String, ?> var3, @Define(value="cond") String var4);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(<nameHashColumn>) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table> <postgresCond>", connectionType=ConnectionType.POSTGRES)})
    public int listCount(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @BindMap Map<String, ?> var3, @Define(value="mysqlCond") String var4, @Define(value="postgresCond") String var5);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <table>.name, <table>.id, <table>.json FROM <table> <mysqlCond> AND (<table>.name < :beforeName OR (<table>.name = :beforeName AND <table>.id < :beforeId)) ORDER BY <table>.name DESC,<table>.id DESC LIMIT :limit) last_rows_subquery ORDER BY name,id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <table>.name, <table>.id, <table>.json FROM <table> <postgresCond> AND (<table>.name < :beforeName OR (<table>.name = :beforeName AND <table>.id < :beforeId)) ORDER BY <table>.name DESC,<table>.id DESC LIMIT :limit) last_rows_subquery ORDER BY name,id", connectionType=ConnectionType.POSTGRES)})
    public List<String> listBefore(@Define(value="table") String var1, @BindMap Map<String, ?> var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="limit") int var5, @Bind(value="beforeName") String var6, @Bind(value="beforeId") String var7);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT <table>.json FROM <table> <mysqlCond> AND (<table>.name > :afterName OR (<table>.name = :afterName AND <table>.id > :afterId)) ORDER BY <table>.name,<table>.id LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT <table>.json FROM <table> <postgresCond> AND (<table>.name > :afterName OR (<table>.name = :afterName AND <table>.id > :afterId)) ORDER BY <table>.name,<table>.id LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
    public List<String> listAfter(@Define(value="table") String var1, @BindMap Map<String, ?> var2, @Define(value="mysqlCond") String var3, @Define(value="postgresCond") String var4, @Bind(value="limit") int var5, @Bind(value="afterName") String var6, @Bind(value="afterId") String var7);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(<nameHashColumn>) FROM <table>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(*) FROM <table>", connectionType=ConnectionType.POSTGRES)})
    public int listTotalCount(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT count(distinct(<distinctColumn>)) FROM <table> <mysqlCond>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT count(distinct(<distinctColumn>)) FROM <table> <postgresCond>", connectionType=ConnectionType.POSTGRES)})
    public int listCountDistinct(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3, @Define(value="distinctColumn") String var4);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <table>.name, <table>.id, <table>.json FROM <table> <mysqlCond> AND (<table>.name < :beforeName OR (<table>.name = :beforeName AND <table>.id < :beforeId))  <groupBy> ORDER BY <table>.name DESC,<table>.id DESC LIMIT :limit) last_rows_subquery ORDER BY name,id", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT json FROM (SELECT <table>.name, <table>.id, <table>.json FROM <table> <postgresCond> AND (<table>.name < :beforeName OR (<table>.name = :beforeName AND <table>.id < :beforeId))  <groupBy> ORDER BY <table>.name DESC,<table>.id DESC LIMIT :limit) last_rows_subquery ORDER BY name,id", connectionType=ConnectionType.POSTGRES)})
    public List<String> listBefore(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3, @Bind(value="limit") int var4, @Bind(value="beforeName") String var5, @Bind(value="beforeId") String var6, @Define(value="groupBy") String var7);

    @ConnectionAwareSqlQueryContainer(value={@ConnectionAwareSqlQuery(value="SELECT <table>.json FROM <table> <mysqlCond> AND (<table>.name > :afterName OR (<table>.name = :afterName AND <table>.id > :afterId)) <groupBy> ORDER BY <table>.name,<table>.id LIMIT :limit", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlQuery(value="SELECT <table>.json FROM <table> <postgresCond> AND (<table>.name > :afterName OR (<table>.name = :afterName AND <table>.id > :afterId))  <groupBy> ORDER BY <table>.name,<table>.id LIMIT :limit", connectionType=ConnectionType.POSTGRES)})
    public List<String> listAfter(@Define(value="table") String var1, @Define(value="mysqlCond") String var2, @Define(value="postgresCond") String var3, @Bind(value="limit") int var4, @Bind(value="afterName") String var5, @Bind(value="afterId") String var6, @Define(value="groupBy") String var7);

    @SqlQuery(value="SELECT json FROM (SELECT id,name, json FROM <table> <cond> AND (name < :beforeName OR (name = :beforeName AND id < :beforeId))  ORDER BY name DESC, id DESC LIMIT :limit) last_rows_subquery ORDER BY name,id")
    public List<String> listBefore(@Define(value="table") String var1, @BindMap Map<String, ?> var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="beforeName") String var5, @Bind(value="beforeId") String var6);

    @SqlQuery(value="SELECT json FROM <table> <cond> AND (<table>.name > :afterName OR (<table>.name = :afterName AND <table>.id > :afterId)) ORDER BY name,id LIMIT :limit")
    public List<String> listAfter(@Define(value="table") String var1, @BindMap Map<String, ?> var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="afterName") String var5, @Bind(value="afterId") String var6);

    @SqlQuery(value="SELECT json FROM <table> LIMIT :limit OFFSET :offset")
    public List<String> listAfterWithOffset(@Define(value="table") String var1, @Bind(value="limit") int var2, @Bind(value="offset") int var3);

    @SqlQuery(value="SELECT json FROM <table> WHERE <nameHashColumn> = '' or <nameHashColumn> is null LIMIT :limit")
    public List<String> migrationListAfterWithOffset(@Define(value="table") String var1, @Define(value="nameHashColumn") String var2, @Bind(value="limit") int var3);

    @SqlQuery(value="SELECT json FROM <table> <cond> ORDER BY name LIMIT :limit OFFSET :offset")
    public List<String> listAfter(@Define(value="table") String var1, @BindMap Map<String, ?> var2, @Define(value="cond") String var3, @Bind(value="limit") int var4, @Bind(value="offset") int var5);

    @SqlQuery(value="SELECT EXISTS (SELECT * FROM <table> WHERE id = :id)")
    public boolean exists(@Define(value="table") String var1, @BindUUID(value="id") UUID var2);

    @SqlQuery(value="SELECT EXISTS (SELECT * FROM <table> WHERE <nameColumnHash> = :fqnHash)")
    public boolean existsByName(@Define(value="table") String var1, @Define(value="nameColumnHash") String var2, @BindFQN(value="fqnHash") String var3);

    @SqlUpdate(value="DELETE FROM <table> WHERE id = :id")
    public int delete(@Define(value="table") String var1, @BindUUID(value="id") UUID var2);

    @ConnectionAwareSqlUpdateContainer(value={@ConnectionAwareSqlUpdate(value="ANALYZE TABLE <table>", connectionType=ConnectionType.MYSQL), @ConnectionAwareSqlUpdate(value="ANALYZE <table>", connectionType=ConnectionType.POSTGRES)})
    public void analyze(@Define(value="table") String var1);

    default public void analyzeTable() {
        this.analyze(this.getTableName());
    }

    default public void insert(EntityInterface entity, String fqn) {
        this.insert(this.getTableName(), this.getNameHashColumn(), fqn, JsonUtils.pojoToJson(entity));
    }

    default public void insert(String nameHash, EntityInterface entity, String fqn) {
        this.insert(this.getTableName(), nameHash, fqn, JsonUtils.pojoToJson(entity));
    }

    default public void update(UUID id, String fqn, String json) {
        this.update(this.getTableName(), this.getNameHashColumn(), fqn, id.toString(), json);
    }

    default public void update(EntityInterface entity) {
        this.update(this.getTableName(), this.getNameHashColumn(), entity.getFullyQualifiedName(), entity.getId().toString(), JsonUtils.pojoToJson(entity));
    }

    default public void update(String nameHashColumn, EntityInterface entity) {
        this.update(this.getTableName(), nameHashColumn, entity.getFullyQualifiedName(), entity.getId().toString(), JsonUtils.pojoToJson(entity));
    }

    default public String getCondition(Include include) {
        if (!this.supportsSoftDelete()) {
            return "";
        }
        if (include == null || include == Include.NON_DELETED) {
            return "AND deleted = FALSE";
        }
        return include == Include.DELETED ? " AND deleted = TRUE" : "";
    }

    default public T findEntityById(UUID id, Include include) {
        return this.jsonToEntity(this.findById(this.getTableName(), id, this.getCondition(include)), id);
    }

    default public T findEntityById(UUID id) {
        return this.findEntityById(id, Include.NON_DELETED);
    }

    default public T findEntityByName(String fqn) {
        return this.findEntityByName(fqn, Include.NON_DELETED);
    }

    default public T findEntityByName(String fqn, Include include) {
        return this.jsonToEntity(this.findByName(this.getTableName(), this.getNameHashColumn(), fqn, this.getCondition(include)), fqn);
    }

    default public T findEntityByName(String fqn, String nameHashColumn, Include include) {
        return this.jsonToEntity(this.findByName(this.getTableName(), nameHashColumn, fqn, this.getCondition(include)), fqn);
    }

    default public T jsonToEntity(String json, Object identity) {
        EntityInterface entity;
        Class<T> clz = this.getEntityClass();
        EntityInterface entityInterface = entity = json != null ? (EntityInterface)JsonUtils.readValue(json, clz) : null;
        if (entity == null) {
            String entityType = Entity.getEntityTypeFromClass(clz);
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, identity.toString()));
        }
        return (T)entity;
    }

    default public int listCount(ListFilter filter) {
        return this.listCount(this.getTableName(), this.getNameHashColumn(), filter.getQueryParams(), filter.getCondition());
    }

    default public int listTotalCount() {
        return this.listTotalCount(this.getTableName(), this.getNameHashColumn());
    }

    default public List<String> listBefore(ListFilter filter, int limit, String beforeName, String beforeId) {
        return this.listBefore(this.getTableName(), filter.getQueryParams(), filter.getCondition(), limit, beforeName, beforeId);
    }

    default public List<String> listAfter(ListFilter filter, int limit, String afterName, String afterId) {
        return this.listAfter(this.getTableName(), filter.getQueryParams(), filter.getCondition(), limit, afterName, afterId);
    }

    default public List<String> listAfterWithOffset(int limit, int offset) {
        return this.listAfterWithOffset(this.getTableName(), limit, offset);
    }

    default public List<String> migrationListAfterWithOffset(int limit, String nameHashColumn) {
        return this.migrationListAfterWithOffset(this.getTableName(), nameHashColumn, limit);
    }

    default public List<String> listAfter(ListFilter filter, int limit, int offset) {
        return this.listAfter(this.getTableName(), filter.getQueryParams(), filter.getCondition(), limit, offset);
    }

    default public void exists(UUID id) {
        if (!this.exists(this.getTableName(), id)) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, id));
        }
    }

    default public void existsByName(String fqn) {
        if (!this.existsByName(this.getTableName(), this.getNameHashColumn(), fqn)) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, fqn));
        }
    }

    default public void delete(UUID id) {
        int rowsDeleted = this.delete(this.getTableName(), id);
        if (rowsDeleted <= 0) {
            String entityType = Entity.getEntityTypeFromClass(this.getEntityClass());
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound(entityType, id));
        }
    }
}

