/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.Argument;
import org.openmetadata.schema.entity.events.ArgumentsInput;
import org.openmetadata.schema.entity.events.EventFilterRule;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.scheduled.EventSubscriptionScheduler;
import org.openmetadata.service.events.subscription.AlertUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscriptionRepository
extends EntityRepository<EventSubscription> {
    private static final Logger LOG = LoggerFactory.getLogger(EventSubscriptionRepository.class);
    static final String ALERT_PATCH_FIELDS = "trigger,enabled,batchSize";
    static final String ALERT_UPDATE_FIELDS = "trigger,enabled,batchSize,input,filteringRules";

    public EventSubscriptionRepository() {
        super("/v1/events/subscriptions", "eventsubscription", EventSubscription.class, Entity.getCollectionDAO().eventSubscriptionDAO(), ALERT_PATCH_FIELDS, ALERT_UPDATE_FIELDS);
    }

    @Override
    public void setFields(EventSubscription entity, EntityUtil.Fields fields) {
        if (fields.contains("statusDetails") && !entity.getDestinations().isEmpty()) {
            ArrayList destinations = new ArrayList();
            entity.getDestinations().forEach(destination -> destinations.add(destination.withStatusDetails(EventSubscriptionScheduler.getInstance().getStatusForEventSubscription(entity.getId(), destination.getId()))));
            entity.withDestinations(destinations);
        }
    }

    @Override
    public void clearFields(EventSubscription entity, EntityUtil.Fields fields) {
    }

    @Override
    public void prepare(EventSubscription entity, boolean update) {
        if (entity.getInput() != null) {
            CommonUtil.listOrEmpty((List)entity.getInput().getFilters()).sort(Comparator.comparing(ArgumentsInput::getName));
            CommonUtil.listOrEmpty((List)entity.getInput().getActions()).sort(Comparator.comparing(ArgumentsInput::getName));
            CommonUtil.listOrEmpty((List)entity.getInput().getFilters()).forEach(filter -> CommonUtil.listOrEmpty((List)filter.getArguments()).sort(Comparator.comparing(Argument::getName)));
            CommonUtil.listOrEmpty((List)entity.getInput().getActions()).forEach(filter -> CommonUtil.listOrEmpty((List)filter.getArguments()).sort(Comparator.comparing(Argument::getName)));
        }
        if (update && !CommonUtil.nullOrEmpty((Object)entity.getFilteringRules())) {
            entity.setFilteringRules(AlertUtil.validateAndBuildFilteringConditions(entity.getFilteringRules().getResources(), entity.getAlertType(), entity.getInput()));
        }
        this.validateFilterRules(entity);
    }

    private void validateFilterRules(EventSubscription entity) {
        if (entity.getFilteringRules() != null) {
            List rules = entity.getFilteringRules().getRules();
            for (EventFilterRule rule : rules) {
                AlertUtil.validateExpression(rule.getCondition(), Boolean.class);
            }
            rules.sort(Comparator.comparing(EventFilterRule::getName));
        }
    }

    @Override
    public void storeEntity(EventSubscription entity, boolean update) {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(EventSubscription entity) {
    }

    public EventSubscriptionUpdater getUpdater(EventSubscription original, EventSubscription updated, EntityRepository.Operation operation) {
        return new EventSubscriptionUpdater(original, updated, operation);
    }

    public class EventSubscriptionUpdater
    extends EntityRepository.EntityUpdater {
        public EventSubscriptionUpdater(EventSubscription original, EventSubscription updated, EntityRepository.Operation operation) {
            super((EntityRepository)EventSubscriptionRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.recordChange("input", ((EventSubscription)this.original).getInput(), ((EventSubscription)this.updated).getInput(), true);
            this.recordChange("batchSize", ((EventSubscription)this.original).getBatchSize(), ((EventSubscription)this.updated).getBatchSize());
            if (!((EventSubscription)this.original).getAlertType().equals((Object)CreateEventSubscription.AlertType.ACTIVITY_FEED)) {
                this.recordChange("filteringRules", ((EventSubscription)this.original).getFilteringRules(), ((EventSubscription)this.updated).getFilteringRules(), true);
                this.recordChange("enabled", ((EventSubscription)this.original).getEnabled(), ((EventSubscription)this.updated).getEnabled());
                this.recordChange("destinations", ((EventSubscription)this.original).getDestinations(), ((EventSubscription)this.updated).getDestinations(), true);
                this.recordChange("trigger", ((EventSubscription)this.original).getTrigger(), ((EventSubscription)this.updated).getTrigger(), true);
            }
        }
    }
}

