/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.core.SecurityContext;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.tests.type.ColumnTestSummaryDefinition;
import org.openmetadata.schema.tests.type.TestSummary;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteRepository
extends EntityRepository<TestSuite> {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteRepository.class);
    private static final String UPDATE_FIELDS = "tests";
    private static final String PATCH_FIELDS = "tests";
    private static final String EXECUTION_SUMMARY_AGGS = "{\n  \"aggregations\": {\n      \"status_counts\": {\n        \"terms\": {\n          \"field\": \"testCaseResult.testCaseStatus\"\n        }\n      }\n    }\n}\n";
    private static final String ENTITY_EXECUTION_SUMMARY_AGGS = "{\n  \"aggregations\": {\n    \"entityLinks\": {\n      \"terms\": {\n        \"field\": \"entityLink.nonNormalized\"\n      },\n      \"aggs\": {\n        \"status_counts\": {\n          \"terms\": {\n            \"field\": \"testCaseResult.testCaseStatus\"\n          }\n        }\n      }\n    }\n  }\n}";
    private static final String ENTITY_EXECUTION_SUMMARY_FILTER = "    {\n      \"query\": {\n        \"bool\": {\n            \"should\": [\n                {\n                    \"nested\":{\n                        \"path\": \"testSuites\",\n                        \"query\": {\n                            \"term\": {\n                                \"testSuites.id\": \"%1$s\"\n                            }\n                        }\n                    }\n                },\n                {\n                    \"term\": {\n                        \"testSuite.id\": \"%1$s\"\n                    }\n                }\n            ]\n          }\n      }\n    }\n";

    public TestSuiteRepository() {
        super("/v1/dataQuality/testSuites", "testSuite", TestSuite.class, Entity.getCollectionDAO().testSuiteDAO(), "tests", "tests");
        this.quoteFqn = false;
        this.supportsSearch = true;
    }

    @Override
    public void setFields(TestSuite entity, EntityUtil.Fields fields) {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : entity.getPipelines());
        entity.setSummary(fields.contains("summary") ? this.getTestSummary(entity.getId()) : entity.getSummary());
        entity.withTests(fields.contains("tests") ? this.getTestCases(entity) : entity.getTests());
    }

    @Override
    public void setInheritedFields(TestSuite testSuite, EntityUtil.Fields fields) {
        if (Boolean.TRUE.equals(testSuite.getExecutable())) {
            Table table = (Table)Entity.getEntity("table", testSuite.getExecutableEntityReference().getId(), "owner", Include.ALL);
            this.inheritOwner(testSuite, fields, (EntityInterface)table);
        }
    }

    @Override
    public void clearFields(TestSuite entity, EntityUtil.Fields fields) {
        entity.setPipelines(fields.contains("pipelines") ? entity.getPipelines() : null);
        entity.setSummary(fields.contains("summary") ? entity.getSummary() : null);
        entity.withTests(fields.contains("tests") ? entity.getTests() : null);
    }

    @Override
    public void setFullyQualifiedName(TestSuite testSuite) {
        if (testSuite.getExecutableEntityReference() != null) {
            testSuite.setFullyQualifiedName(FullyQualifiedName.add(testSuite.getExecutableEntityReference().getFullyQualifiedName(), "testSuite"));
        } else {
            testSuite.setFullyQualifiedName(FullyQualifiedName.quoteName(testSuite.getName()));
        }
    }

    private TestSummary getTestCasesExecutionSummary(JsonObject aggregation) {
        TestSummary testSummary = new TestSummary().withAborted(Integer.valueOf(0)).withFailed(Integer.valueOf(0)).withSuccess(Integer.valueOf(0)).withQueued(Integer.valueOf(0)).withTotal(Integer.valueOf(0));
        Optional<JsonObject> summary = Optional.ofNullable(aggregation.getJsonObject("sterms#status_counts"));
        return summary.map(s -> {
            JsonArray buckets = s.getJsonArray("buckets");
            for (JsonValue bucket : buckets) {
                this.updateTestSummaryFromBucket((JsonObject)bucket, testSummary);
            }
            return testSummary;
        }).orElse(testSummary);
    }

    private TestSummary getEntityTestCasesExecutionSummary(JsonObject aggregation) {
        TestSummary testSummary = new TestSummary().withAborted(Integer.valueOf(0)).withFailed(Integer.valueOf(0)).withSuccess(Integer.valueOf(0)).withQueued(Integer.valueOf(0)).withTotal(Integer.valueOf(0));
        ArrayList columnTestSummaries = new ArrayList();
        Optional<JsonObject> entityLinkAgg = Optional.ofNullable(SearchClient.getAggregationObject(aggregation, "sterms#entityLinks"));
        return entityLinkAgg.map(entityLinkAggJson -> {
            JsonArray entityLinkBuckets = SearchClient.getAggregationBuckets(entityLinkAggJson);
            for (JsonValue entityLinkBucket : entityLinkBuckets) {
                JsonObject statusAgg = SearchClient.getAggregationObject((JsonObject)entityLinkBucket, "sterms#status_counts");
                JsonArray statusBuckets = SearchClient.getAggregationBuckets(statusAgg);
                String entityLinkString = SearchClient.getAggregationKeyValue((JsonObject)entityLinkBucket);
                MessageParser.EntityLink entityLink = entityLinkString != null ? MessageParser.EntityLink.parse(entityLinkString) : null;
                ColumnTestSummaryDefinition columnTestSummary = new ColumnTestSummaryDefinition().withAborted(Integer.valueOf(0)).withFailed(Integer.valueOf(0)).withSuccess(Integer.valueOf(0)).withQueued(Integer.valueOf(0)).withTotal(Integer.valueOf(0)).withEntityLink(entityLinkString);
                for (JsonValue statusBucket : statusBuckets) {
                    this.updateColumnTestSummaryFromBucket((JsonObject)statusBucket, columnTestSummary);
                    this.updateTestSummaryFromBucket((JsonObject)statusBucket, testSummary);
                    if (entityLink == null || entityLink.getFieldName() == null || !entityLink.getFieldName().equals("columns")) continue;
                    columnTestSummaries.add(columnTestSummary);
                }
            }
            testSummary.setColumnTestSummary(columnTestSummaries);
            return testSummary;
        }).orElse(testSummary);
    }

    public TestSummary getTestSummary(UUID testSuiteId) {
        JsonObject aggregationJson = JsonUtils.readJson(EXECUTION_SUMMARY_AGGS).asJsonObject();
        try {
            TestSummary testSummary;
            if (testSuiteId == null) {
                JsonObject testCaseResultSummary = this.searchRepository.aggregate(null, "testCase", aggregationJson);
                testSummary = this.getTestCasesExecutionSummary(testCaseResultSummary);
            } else {
                String query = ENTITY_EXECUTION_SUMMARY_FILTER.formatted(testSuiteId);
                aggregationJson = JsonUtils.readJson(ENTITY_EXECUTION_SUMMARY_AGGS).asJsonObject();
                JsonObject testCaseResultSummary = this.searchRepository.aggregate(query, "testCase", aggregationJson);
                testSummary = this.getEntityTestCasesExecutionSummary(testCaseResultSummary);
            }
            return testSummary;
        }
        catch (Exception e) {
            LOG.error("Error reading aggregation query", (Throwable)e);
            return null;
        }
    }

    @Override
    public void prepare(TestSuite entity, boolean update) {
    }

    private List<EntityReference> getTestCases(TestSuite entity) {
        return this.findTo(entity.getId(), "testSuite", Relationship.CONTAINS, "testCase");
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
        return new TestSuiteUpdater(original, updated, operation);
    }

    @Override
    public void storeEntity(TestSuite entity, boolean update) {
        List tests = entity.getTests();
        entity.setTests(null);
        this.store(entity, update);
        entity.setTests(tests);
    }

    @Override
    public void storeRelationships(TestSuite entity) {
        if (Boolean.TRUE.equals(entity.getExecutable())) {
            this.storeExecutableRelationship(entity);
        }
    }

    public void storeExecutableRelationship(TestSuite testSuite) {
        Table table = (Table)Entity.getEntityByName("table", testSuite.getExecutableEntityReference().getFullyQualifiedName(), null, null);
        this.addRelationship(table.getId(), testSuite.getId(), "table", "testSuite", Relationship.CONTAINS);
    }

    public RestUtil.DeleteResponse<TestSuite> deleteLogicalTestSuite(SecurityContext securityContext, TestSuite original, boolean hardDelete) {
        EventType changeType;
        String updatedBy = securityContext.getUserPrincipal().getName();
        this.preDelete(original, updatedBy);
        this.setFieldsInternal(original, this.putFields);
        TestSuite updated = JsonUtils.readValue(JsonUtils.pojoToJson(original), TestSuite.class);
        this.setFieldsInternal(updated, this.putFields);
        if (this.supportsSoftDelete && !hardDelete) {
            updated.setUpdatedBy(updatedBy);
            updated.setUpdatedAt(Long.valueOf(System.currentTimeMillis()));
            updated.setDeleted(Boolean.valueOf(true));
            EntityRepository.EntityUpdater updater = this.getUpdater(original, updated, EntityRepository.Operation.SOFT_DELETE);
            updater.update();
            changeType = EventType.ENTITY_SOFT_DELETED;
        } else {
            this.cleanup(updated);
            changeType = EventType.ENTITY_DELETED;
        }
        LOG.info("{} deleted {}", (Object)(hardDelete ? "Hard" : "Soft"), (Object)updated.getFullyQualifiedName());
        return new RestUtil.DeleteResponse<TestSuite>(updated, changeType);
    }

    private void updateTestSummaryFromBucket(JsonObject bucket, TestSummary testSummary) {
        String key = bucket.getString("key");
        Integer count = bucket.getJsonNumber("doc_count").intValue();
        switch (key) {
            case "success": {
                testSummary.setSuccess(Integer.valueOf(testSummary.getSuccess() + count));
                break;
            }
            case "failed": {
                testSummary.setFailed(Integer.valueOf(testSummary.getFailed() + count));
                break;
            }
            case "aborted": {
                testSummary.setAborted(Integer.valueOf(testSummary.getAborted() + count));
                break;
            }
            case "queued": {
                testSummary.setQueued(Integer.valueOf(testSummary.getQueued() + count));
            }
        }
        testSummary.setTotal(Integer.valueOf(testSummary.getTotal() + count));
    }

    private void updateColumnTestSummaryFromBucket(JsonObject bucket, ColumnTestSummaryDefinition columnTestSummary) {
        String key = bucket.getString("key");
        Integer count = bucket.getJsonNumber("doc_count").intValue();
        switch (key) {
            case "success": {
                columnTestSummary.setSuccess(Integer.valueOf(columnTestSummary.getSuccess() + count));
                break;
            }
            case "failed": {
                columnTestSummary.setFailed(Integer.valueOf(columnTestSummary.getFailed() + count));
                break;
            }
            case "aborted": {
                columnTestSummary.setAborted(Integer.valueOf(columnTestSummary.getAborted() + count));
                break;
            }
            case "queued": {
                columnTestSummary.setQueued(Integer.valueOf(columnTestSummary.getQueued() + count));
            }
        }
        columnTestSummary.setTotal(Integer.valueOf(columnTestSummary.getTotal() + count));
    }

    public static TestSuite copyTestSuite(TestSuite testSuite) {
        return new TestSuite().withConnection(testSuite.getConnection()).withDescription(testSuite.getDescription()).withChangeDescription(testSuite.getChangeDescription()).withDeleted(testSuite.getDeleted()).withDisplayName(testSuite.getDisplayName()).withFullyQualifiedName(testSuite.getFullyQualifiedName()).withHref(testSuite.getHref()).withId(testSuite.getId()).withName(testSuite.getName()).withExecutable(testSuite.getExecutable()).withExecutableEntityReference(testSuite.getExecutableEntityReference()).withServiceType(testSuite.getServiceType()).withOwner(testSuite.getOwner()).withUpdatedBy(testSuite.getUpdatedBy()).withUpdatedAt(testSuite.getUpdatedAt()).withVersion(testSuite.getVersion());
    }

    public class TestSuiteUpdater
    extends EntityRepository.EntityUpdater {
        public TestSuiteUpdater(TestSuite original, TestSuite updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestSuiteRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            List origTests = CommonUtil.listOrEmpty((List)((TestSuite)this.original).getTests());
            List updatedTests = CommonUtil.listOrEmpty((List)((TestSuite)this.updated).getTests());
            List origTestCaseResultSummary = CommonUtil.listOrEmpty((List)((TestSuite)this.original).getTestCaseResultSummary());
            List updatedTestCaseResultSummary = CommonUtil.listOrEmpty((List)((TestSuite)this.updated).getTestCaseResultSummary());
            this.recordChange("tests", origTests, updatedTests);
            this.recordChange("testCaseResultSummary", origTestCaseResultSummary, updatedTestCaseResultSummary);
        }
    }
}

