/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.mysql.v110;

import java.util.Collections;
import java.util.Map;
import org.openmetadata.service.migration.QueryStatus;
import org.openmetadata.service.migration.api.MigrationProcessImpl;
import org.openmetadata.service.migration.utils.MigrationFile;
import org.openmetadata.service.migration.utils.v110.MigrationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration
extends MigrationProcessImpl {
    private static final Logger LOG = LoggerFactory.getLogger(Migration.class);

    public Migration(MigrationFile migrationFile) {
        super(migrationFile);
    }

    @Override
    public void runDataMigration() {
        String envVariableValue = System.getenv("MIGRATION_LIMIT_PARAM");
        if (envVariableValue != null) {
            MigrationUtil.dataMigrationFQNHashing(this.handle, this.collectionDAO, Integer.parseInt(envVariableValue));
        } else {
            MigrationUtil.dataMigrationFQNHashing(this.handle, this.collectionDAO, 1000);
        }
    }

    @Override
    public Map<String, QueryStatus> runPostDDLScripts(boolean isForceMigration) {
        super.runPostDDLScripts(isForceMigration);
        MigrationUtil.testSuitesMigration(this.collectionDAO);
        return Collections.emptyMap();
    }
}

