/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.auth0.jwt.interfaces.Claim;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.SecurityContext;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.configuration.LoginConfiguration;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.security.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);
    public static final String DEFAULT_PRINCIPAL_DOMAIN = "openmetadata.org";

    private SecurityUtil() {
    }

    public static String getUserName(SecurityContext securityContext) {
        Principal principal = securityContext.getUserPrincipal();
        return principal == null ? null : principal.getName().split("[/@]")[0];
    }

    public static LoginConfiguration getLoginConfiguration() {
        return SettingsCache.getSetting(SettingsType.LOGIN_CONFIGURATION, LoginConfiguration.class);
    }

    public static Map<String, String> authHeaders(String username) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (username != null) {
            builder.put((Object)"X-Auth-Params-Email", (Object)username);
        }
        return builder.build();
    }

    public static String getPrincipalName(Map<String, String> authHeaders) {
        if (authHeaders == null) {
            return null;
        }
        String principal = authHeaders.get("X-Auth-Params-Email");
        return principal == null ? null : principal.split("@")[0];
    }

    public static String getDomain(OpenMetadataApplicationConfig config) {
        String principalDomain = config.getAuthorizerConfiguration().getPrincipalDomain();
        return CommonUtil.nullOrEmpty((String)principalDomain) ? DEFAULT_PRINCIPAL_DOMAIN : principalDomain;
    }

    public static Invocation.Builder addHeaders(WebTarget target, Map<String, String> headers) {
        if (headers != null) {
            return target.request().header("X-Auth-Params-Email", (Object)headers.get("X-Auth-Params-Email"));
        }
        return target.request();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findUserNameFromClaims(Map<String, String> jwtPrincipalClaimsMapping, List<String> jwtPrincipalClaimsOrder, Map<String, ?> claims) {
        String userName;
        if (!CommonUtil.nullOrEmpty(jwtPrincipalClaimsMapping)) {
            String usernameClaim = jwtPrincipalClaimsMapping.get("username");
            String userNameClaimValue = SecurityUtil.getClaimOrObject(claims.get(usernameClaim));
            if (CommonUtil.nullOrEmpty((String)userNameClaimValue)) throw new AuthenticationException("Invalid JWT token, 'username' claim is not present");
            userName = userNameClaimValue;
            return userName.toLowerCase();
        } else {
            String jwtClaim = SecurityUtil.getFirstMatchJwtClaim(jwtPrincipalClaimsOrder, claims);
            userName = jwtClaim.contains("@") ? jwtClaim.split("@")[0] : jwtClaim;
        }
        return userName.toLowerCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findEmailFromClaims(Map<String, String> jwtPrincipalClaimsMapping, List<String> jwtPrincipalClaimsOrder, Map<String, ?> claims, String defaulPrincipalClaim) {
        String email;
        if (!CommonUtil.nullOrEmpty(jwtPrincipalClaimsMapping)) {
            String emailClaim = jwtPrincipalClaimsMapping.get("email");
            String emailClaimValue = SecurityUtil.getClaimOrObject(claims.get(emailClaim));
            if (CommonUtil.nullOrEmpty((String)emailClaimValue) || !emailClaimValue.contains("@")) throw new AuthenticationException(String.format("Invalid JWT token, 'email' claim is not present or invalid : %s", emailClaimValue));
            email = emailClaimValue;
            return email.toLowerCase();
        } else {
            String jwtClaim = SecurityUtil.getFirstMatchJwtClaim(jwtPrincipalClaimsOrder, claims);
            email = jwtClaim.contains("@") ? jwtClaim : String.format("%s@%s", jwtClaim, defaulPrincipalClaim);
        }
        return email.toLowerCase();
    }

    public static String getClaimOrObject(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Claim) {
            Claim c = (Claim)obj;
            return c.asString();
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return s;
        }
        return "";
    }

    public static String getFirstMatchJwtClaim(List<String> jwtPrincipalClaimsOrder, Map<String, ?> claims) {
        return jwtPrincipalClaimsOrder.stream().filter(claims::containsKey).findFirst().map(claims::get).map(SecurityUtil::getClaimOrObject).orElseThrow(() -> new AuthenticationException("Invalid JWT token, none of the following claims are present " + jwtPrincipalClaimsOrder));
    }

    public static void validatePrincipalClaimsMapping(Map<String, String> mapping) {
        if (!CommonUtil.nullOrEmpty(mapping)) {
            String username = mapping.get("username");
            String email = mapping.get("email");
            if (CommonUtil.nullOrEmpty((String)username) || CommonUtil.nullOrEmpty((String)email)) {
                throw new IllegalArgumentException("Invalid JWT Principal Claims Mapping. Both username and email should be present");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validateDomainEnforcement(Map<String, String> jwtPrincipalClaimsMapping, List<String> jwtPrincipalClaimsOrder, Map<String, Claim> claims, String principalDomain, boolean enforcePrincipalDomain) {
        String domain = "";
        if (!CommonUtil.nullOrEmpty(jwtPrincipalClaimsMapping)) {
            String emailClaim = jwtPrincipalClaimsMapping.get("email");
            String emailClaimValue = SecurityUtil.getClaimOrObject(claims.get(emailClaim));
            if (CommonUtil.nullOrEmpty((String)emailClaimValue)) throw new AuthenticationException("Invalid JWT token, 'email' claim is not present");
            if (emailClaimValue.contains("@")) {
                domain = emailClaimValue.split("@")[1];
            }
        } else {
            String jwtClaim = SecurityUtil.getFirstMatchJwtClaim(jwtPrincipalClaimsOrder, claims);
            if (jwtClaim.contains("@")) {
                domain = jwtClaim.split("@")[1];
            }
        }
        if (SecurityUtil.isBot(claims) || !enforcePrincipalDomain || domain.equals(principalDomain)) return;
        throw new AuthenticationException(String.format("Not Authorized! Email does not match the principal domain %s", principalDomain));
    }

    public static boolean isBot(Map<String, Claim> claims) {
        return claims.containsKey("isBot") && Boolean.TRUE.equals(claims.get("isBot").asBoolean());
    }
}

