/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.openmetadata.schema.auth.CreatePersonalToken;
import org.openmetadata.schema.auth.EmailVerificationToken;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.PasswordResetToken;
import org.openmetadata.schema.auth.PersonalAccessToken;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.TokenType;
import org.openmetadata.schema.entity.teams.User;

public class TokenUtil {
    private TokenUtil() {
    }

    public static EmailVerificationToken getEmailVerificationToken(UUID userId, UUID token) {
        EmailVerificationToken emailVerificationToken = new EmailVerificationToken();
        emailVerificationToken.setToken(token);
        emailVerificationToken.setTokenType(TokenType.EMAIL_VERIFICATION);
        emailVerificationToken.setTokenStatus(EmailVerificationToken.TokenStatus.STATUS_PENDING);
        emailVerificationToken.setUserId(userId);
        emailVerificationToken.setExpiryDate(Long.valueOf(Instant.now().plus(24L, ChronoUnit.HOURS).toEpochMilli()));
        return emailVerificationToken;
    }

    public static PasswordResetToken getPasswordResetToken(UUID userId, UUID token) {
        PasswordResetToken passwordResetToken = new PasswordResetToken();
        passwordResetToken.setToken(token);
        passwordResetToken.setTokenType(TokenType.PASSWORD_RESET);
        passwordResetToken.setIsActive(Boolean.valueOf(true));
        passwordResetToken.setIsClaimed(Boolean.valueOf(false));
        passwordResetToken.setUserId(userId);
        passwordResetToken.setExpiryDate(Long.valueOf(Instant.now().plus(1L, ChronoUnit.HOURS).toEpochMilli()));
        return passwordResetToken;
    }

    public static RefreshToken getRefreshToken(UUID userId, UUID token) {
        RefreshToken refreshToken = new RefreshToken();
        refreshToken.setToken(token);
        refreshToken.setTokenType(TokenType.REFRESH_TOKEN);
        refreshToken.setUserId(userId);
        refreshToken.setRefreshCount(Integer.valueOf(0));
        refreshToken.setMaxRefreshCount(Integer.valueOf(3));
        refreshToken.setExpiryDate(Long.valueOf(Instant.now().plus(30L, ChronoUnit.DAYS).toEpochMilli()));
        return refreshToken;
    }

    public static RefreshToken getRefreshTokenForLDAP(UUID userId, UUID token) {
        RefreshToken refreshToken = TokenUtil.getRefreshToken(userId, token);
        refreshToken.setExpiryDate(Long.valueOf(Instant.now().plus(24L, ChronoUnit.HOURS).toEpochMilli()));
        return refreshToken;
    }

    public static PersonalAccessToken getPersonalAccessToken(CreatePersonalToken request, User user, JWTAuthMechanism authMechanism) {
        PersonalAccessToken personalAccessToken = new PersonalAccessToken();
        personalAccessToken.setToken(UUID.randomUUID());
        personalAccessToken.setTokenName(request.getTokenName());
        personalAccessToken.setUserId(user.getId());
        personalAccessToken.setTokenType(TokenType.PERSONAL_ACCESS_TOKEN);
        personalAccessToken.setJwtToken(authMechanism.getJWTToken());
        personalAccessToken.setExpiryDate(authMechanism.getJWTTokenExpiresAt());
        return personalAccessToken;
    }
}

