/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import io.dropwizard.jersey.validation.DropwizardConfiguredValidator;
import java.util.Arrays;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.csv.CSVRecord;

public class ValidatorUtil {
    public static final Validator VALIDATOR;
    public static final String NAME_EMAIL_VOILATION = "Name should be equal to the email prefix (before `@`)";

    private ValidatorUtil() {
    }

    public static <T> String validate(T entity) {
        Set violations = VALIDATOR.validate(entity, new Class[0]);
        return violations.isEmpty() ? null : Arrays.toString(violations.stream().map(v -> String.format("%s %s", v.getPropertyPath(), v.getMessage())).toArray());
    }

    public static String validateUserNameWithEmailPrefix(CSVRecord csvRecord) {
        String name = csvRecord.get(0);
        String email = csvRecord.get(3);
        if (name != null && !name.isEmpty() && email != null && !email.isEmpty()) {
            String emailPrefix = "";
            int atIndex = email.indexOf(64);
            if (atIndex != -1) {
                emailPrefix = email.substring(0, atIndex);
            }
            return name.equals(emailPrefix) ? "" : NAME_EMAIL_VOILATION;
        }
        return "";
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        VALIDATOR = new DropwizardConfiguredValidator(factory.getValidator());
    }
}

