/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.catalog.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"strictMode", "tokenValidity", "sendEncryptedNameId", "sendSignedAuthRequest", "signSpMetadata", "wantMessagesSigned", "wantAssertionsSigned", "wantAssertionEncrypted", "wantNameIdEncrypted", "keyStoreFilePath", "keyStoreAlias", "keyStorePassword"})
public class SamlSecurityConfig {
    @JsonProperty(value="strictMode")
    @JsonPropertyDescription(value="Only accept valid signed and encrypted assertions if the relevant flags are set")
    private Boolean strictMode = false;
    @JsonProperty(value="tokenValidity")
    @JsonPropertyDescription(value="Validity for the JWT Token created from SAML Response")
    private Integer tokenValidity = 3600;
    @JsonProperty(value="sendEncryptedNameId")
    @JsonPropertyDescription(value="Encrypt Name Id while sending requests from SP.")
    private Boolean sendEncryptedNameId = false;
    @JsonProperty(value="sendSignedAuthRequest")
    @JsonPropertyDescription(value="Sign the Authn Request while sending.")
    private Boolean sendSignedAuthRequest = false;
    @JsonProperty(value="signSpMetadata")
    @JsonPropertyDescription(value="Want the Metadata of this SP to be signed.")
    private Boolean signSpMetadata = false;
    @JsonProperty(value="wantMessagesSigned")
    @JsonPropertyDescription(value="SP requires the messages received to be signed.")
    private Boolean wantMessagesSigned = false;
    @JsonProperty(value="wantAssertionsSigned")
    @JsonPropertyDescription(value="SP requires the assertions received to be signed.")
    private Boolean wantAssertionsSigned = false;
    @JsonProperty(value="wantAssertionEncrypted")
    @JsonPropertyDescription(value="SP requires the assertion received to be encrypted.")
    private Boolean wantAssertionEncrypted = false;
    @JsonProperty(value="wantNameIdEncrypted")
    @JsonPropertyDescription(value="SP requires the Name Id received to be encrypted.")
    private Boolean wantNameIdEncrypted = false;
    @JsonProperty(value="keyStoreFilePath")
    @JsonPropertyDescription(value="KeyStore File Path")
    private String keyStoreFilePath;
    @JsonProperty(value="keyStoreAlias")
    @JsonPropertyDescription(value="KeyStore Alias")
    private String keyStoreAlias;
    @JsonProperty(value="keyStorePassword")
    @JsonPropertyDescription(value="KeyStore Password")
    private String keyStorePassword;

    @JsonProperty(value="strictMode")
    public Boolean getStrictMode() {
        return this.strictMode;
    }

    @JsonProperty(value="strictMode")
    public void setStrictMode(Boolean strictMode) {
        this.strictMode = strictMode;
    }

    public SamlSecurityConfig withStrictMode(Boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    @JsonProperty(value="tokenValidity")
    public Integer getTokenValidity() {
        return this.tokenValidity;
    }

    @JsonProperty(value="tokenValidity")
    public void setTokenValidity(Integer tokenValidity) {
        this.tokenValidity = tokenValidity;
    }

    public SamlSecurityConfig withTokenValidity(Integer tokenValidity) {
        this.tokenValidity = tokenValidity;
        return this;
    }

    @JsonProperty(value="sendEncryptedNameId")
    public Boolean getSendEncryptedNameId() {
        return this.sendEncryptedNameId;
    }

    @JsonProperty(value="sendEncryptedNameId")
    public void setSendEncryptedNameId(Boolean sendEncryptedNameId) {
        this.sendEncryptedNameId = sendEncryptedNameId;
    }

    public SamlSecurityConfig withSendEncryptedNameId(Boolean sendEncryptedNameId) {
        this.sendEncryptedNameId = sendEncryptedNameId;
        return this;
    }

    @JsonProperty(value="sendSignedAuthRequest")
    public Boolean getSendSignedAuthRequest() {
        return this.sendSignedAuthRequest;
    }

    @JsonProperty(value="sendSignedAuthRequest")
    public void setSendSignedAuthRequest(Boolean sendSignedAuthRequest) {
        this.sendSignedAuthRequest = sendSignedAuthRequest;
    }

    public SamlSecurityConfig withSendSignedAuthRequest(Boolean sendSignedAuthRequest) {
        this.sendSignedAuthRequest = sendSignedAuthRequest;
        return this;
    }

    @JsonProperty(value="signSpMetadata")
    public Boolean getSignSpMetadata() {
        return this.signSpMetadata;
    }

    @JsonProperty(value="signSpMetadata")
    public void setSignSpMetadata(Boolean signSpMetadata) {
        this.signSpMetadata = signSpMetadata;
    }

    public SamlSecurityConfig withSignSpMetadata(Boolean signSpMetadata) {
        this.signSpMetadata = signSpMetadata;
        return this;
    }

    @JsonProperty(value="wantMessagesSigned")
    public Boolean getWantMessagesSigned() {
        return this.wantMessagesSigned;
    }

    @JsonProperty(value="wantMessagesSigned")
    public void setWantMessagesSigned(Boolean wantMessagesSigned) {
        this.wantMessagesSigned = wantMessagesSigned;
    }

    public SamlSecurityConfig withWantMessagesSigned(Boolean wantMessagesSigned) {
        this.wantMessagesSigned = wantMessagesSigned;
        return this;
    }

    @JsonProperty(value="wantAssertionsSigned")
    public Boolean getWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    @JsonProperty(value="wantAssertionsSigned")
    public void setWantAssertionsSigned(Boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
    }

    public SamlSecurityConfig withWantAssertionsSigned(Boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
        return this;
    }

    @JsonProperty(value="wantAssertionEncrypted")
    public Boolean getWantAssertionEncrypted() {
        return this.wantAssertionEncrypted;
    }

    @JsonProperty(value="wantAssertionEncrypted")
    public void setWantAssertionEncrypted(Boolean wantAssertionEncrypted) {
        this.wantAssertionEncrypted = wantAssertionEncrypted;
    }

    public SamlSecurityConfig withWantAssertionEncrypted(Boolean wantAssertionEncrypted) {
        this.wantAssertionEncrypted = wantAssertionEncrypted;
        return this;
    }

    @JsonProperty(value="wantNameIdEncrypted")
    public Boolean getWantNameIdEncrypted() {
        return this.wantNameIdEncrypted;
    }

    @JsonProperty(value="wantNameIdEncrypted")
    public void setWantNameIdEncrypted(Boolean wantNameIdEncrypted) {
        this.wantNameIdEncrypted = wantNameIdEncrypted;
    }

    public SamlSecurityConfig withWantNameIdEncrypted(Boolean wantNameIdEncrypted) {
        this.wantNameIdEncrypted = wantNameIdEncrypted;
        return this;
    }

    @JsonProperty(value="keyStoreFilePath")
    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    @JsonProperty(value="keyStoreFilePath")
    public void setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public SamlSecurityConfig withKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
        return this;
    }

    @JsonProperty(value="keyStoreAlias")
    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    @JsonProperty(value="keyStoreAlias")
    public void setKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public SamlSecurityConfig withKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
        return this;
    }

    @JsonProperty(value="keyStorePassword")
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonProperty(value="keyStorePassword")
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public SamlSecurityConfig withKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SamlSecurityConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("strictMode");
        sb.append('=');
        sb.append(this.strictMode == null ? "<null>" : this.strictMode);
        sb.append(',');
        sb.append("tokenValidity");
        sb.append('=');
        sb.append(this.tokenValidity == null ? "<null>" : this.tokenValidity);
        sb.append(',');
        sb.append("sendEncryptedNameId");
        sb.append('=');
        sb.append(this.sendEncryptedNameId == null ? "<null>" : this.sendEncryptedNameId);
        sb.append(',');
        sb.append("sendSignedAuthRequest");
        sb.append('=');
        sb.append(this.sendSignedAuthRequest == null ? "<null>" : this.sendSignedAuthRequest);
        sb.append(',');
        sb.append("signSpMetadata");
        sb.append('=');
        sb.append(this.signSpMetadata == null ? "<null>" : this.signSpMetadata);
        sb.append(',');
        sb.append("wantMessagesSigned");
        sb.append('=');
        sb.append(this.wantMessagesSigned == null ? "<null>" : this.wantMessagesSigned);
        sb.append(',');
        sb.append("wantAssertionsSigned");
        sb.append('=');
        sb.append(this.wantAssertionsSigned == null ? "<null>" : this.wantAssertionsSigned);
        sb.append(',');
        sb.append("wantAssertionEncrypted");
        sb.append('=');
        sb.append(this.wantAssertionEncrypted == null ? "<null>" : this.wantAssertionEncrypted);
        sb.append(',');
        sb.append("wantNameIdEncrypted");
        sb.append('=');
        sb.append(this.wantNameIdEncrypted == null ? "<null>" : this.wantNameIdEncrypted);
        sb.append(',');
        sb.append("keyStoreFilePath");
        sb.append('=');
        sb.append(this.keyStoreFilePath == null ? "<null>" : this.keyStoreFilePath);
        sb.append(',');
        sb.append("keyStoreAlias");
        sb.append('=');
        sb.append(this.keyStoreAlias == null ? "<null>" : this.keyStoreAlias);
        sb.append(',');
        sb.append("keyStorePassword");
        sb.append('=');
        sb.append(this.keyStorePassword == null ? "<null>" : this.keyStorePassword);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.keyStoreAlias == null ? 0 : this.keyStoreAlias.hashCode());
        result = result * 31 + (this.keyStorePassword == null ? 0 : this.keyStorePassword.hashCode());
        result = result * 31 + (this.strictMode == null ? 0 : this.strictMode.hashCode());
        result = result * 31 + (this.wantMessagesSigned == null ? 0 : this.wantMessagesSigned.hashCode());
        result = result * 31 + (this.tokenValidity == null ? 0 : this.tokenValidity.hashCode());
        result = result * 31 + (this.signSpMetadata == null ? 0 : this.signSpMetadata.hashCode());
        result = result * 31 + (this.sendEncryptedNameId == null ? 0 : this.sendEncryptedNameId.hashCode());
        result = result * 31 + (this.wantAssertionsSigned == null ? 0 : this.wantAssertionsSigned.hashCode());
        result = result * 31 + (this.wantNameIdEncrypted == null ? 0 : this.wantNameIdEncrypted.hashCode());
        result = result * 31 + (this.wantAssertionEncrypted == null ? 0 : this.wantAssertionEncrypted.hashCode());
        result = result * 31 + (this.keyStoreFilePath == null ? 0 : this.keyStoreFilePath.hashCode());
        result = result * 31 + (this.sendSignedAuthRequest == null ? 0 : this.sendSignedAuthRequest.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SamlSecurityConfig)) {
            return false;
        }
        SamlSecurityConfig rhs = (SamlSecurityConfig)other;
        return (this.keyStoreAlias == rhs.keyStoreAlias || this.keyStoreAlias != null && this.keyStoreAlias.equals(rhs.keyStoreAlias)) && (this.keyStorePassword == rhs.keyStorePassword || this.keyStorePassword != null && this.keyStorePassword.equals(rhs.keyStorePassword)) && (this.strictMode == rhs.strictMode || this.strictMode != null && this.strictMode.equals(rhs.strictMode)) && (this.wantMessagesSigned == rhs.wantMessagesSigned || this.wantMessagesSigned != null && this.wantMessagesSigned.equals(rhs.wantMessagesSigned)) && (this.tokenValidity == rhs.tokenValidity || this.tokenValidity != null && this.tokenValidity.equals(rhs.tokenValidity)) && (this.signSpMetadata == rhs.signSpMetadata || this.signSpMetadata != null && this.signSpMetadata.equals(rhs.signSpMetadata)) && (this.sendEncryptedNameId == rhs.sendEncryptedNameId || this.sendEncryptedNameId != null && this.sendEncryptedNameId.equals(rhs.sendEncryptedNameId)) && (this.wantAssertionsSigned == rhs.wantAssertionsSigned || this.wantAssertionsSigned != null && this.wantAssertionsSigned.equals(rhs.wantAssertionsSigned)) && (this.wantNameIdEncrypted == rhs.wantNameIdEncrypted || this.wantNameIdEncrypted != null && this.wantNameIdEncrypted.equals(rhs.wantNameIdEncrypted)) && (this.wantAssertionEncrypted == rhs.wantAssertionEncrypted || this.wantAssertionEncrypted != null && this.wantAssertionEncrypted.equals(rhs.wantAssertionEncrypted)) && (this.keyStoreFilePath == rhs.keyStoreFilePath || this.keyStoreFilePath != null && this.keyStoreFilePath.equals(rhs.keyStoreFilePath)) && (this.sendSignedAuthRequest == rhs.sendSignedAuthRequest || this.sendSignedAuthRequest != null && this.sendSignedAuthRequest.equals(rhs.sendSignedAuthRequest));
    }
}

