/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Votes;

public interface EntityInterface {
    public static final Map<String, String> CANONICAL_ENTITY_NAME_MAP = new HashMap<String, String>();
    public static final Map<String, Class<? extends EntityInterface>> ENTITY_TYPE_TO_CLASS_MAP = new HashMap<String, Class<? extends EntityInterface>>();

    public UUID getId();

    public String getDescription();

    public String getDisplayName();

    public String getName();

    default public Boolean getDeleted() {
        return null;
    }

    public Double getVersion();

    public String getUpdatedBy();

    public Long getUpdatedAt();

    public URI getHref();

    public ChangeDescription getChangeDescription();

    default public EntityReference getOwner() {
        return null;
    }

    default public List<TagLabel> getTags() {
        return null;
    }

    default public ProviderType getProvider() {
        return null;
    }

    default public List<EntityReference> getFollowers() {
        return null;
    }

    default public Votes getVotes() {
        return null;
    }

    public String getFullyQualifiedName();

    default public Object getExtension() {
        return null;
    }

    public void setId(UUID var1);

    public void setDescription(String var1);

    public void setDisplayName(String var1);

    public void setName(String var1);

    public void setVersion(Double var1);

    public void setChangeDescription(ChangeDescription var1);

    public void setFullyQualifiedName(String var1);

    default public void setDeleted(Boolean flag) {
    }

    public void setUpdatedBy(String var1);

    public void setUpdatedAt(Long var1);

    public void setHref(URI var1);

    default public void setTags(List<TagLabel> tags) {
    }

    default public void setOwner(EntityReference owner) {
    }

    default public void setExtension(Object extension) {
    }

    public <T extends EntityInterface> T withHref(URI var1);

    @JsonIgnore
    default public EntityReference getEntityReference() {
        return new EntityReference().withId(this.getId()).withName(this.getName()).withFullyQualifiedName(this.getFullyQualifiedName() == null ? this.getName() : this.getFullyQualifiedName()).withDescription(this.getDescription()).withDisplayName(this.getDisplayName()).withType(CANONICAL_ENTITY_NAME_MAP.get(this.getClass().getSimpleName().toLowerCase(Locale.ROOT))).withDeleted(this.getDeleted()).withHref(this.getHref());
    }
}

