/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.alert.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"receivers", "sendToAdmins", "sendToOwners", "sendToFollowers"})
public class EmailAlertConfig {
    @JsonProperty(value="receivers")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of receivers to send mail to")
    @Valid
    private Set<String> receivers = new LinkedHashSet<String>();
    @JsonProperty(value="sendToAdmins")
    @JsonPropertyDescription(value="Send the Mails to Admins")
    private Boolean sendToAdmins = false;
    @JsonProperty(value="sendToOwners")
    @JsonPropertyDescription(value="Send the Mails to Owners")
    private Boolean sendToOwners = false;
    @JsonProperty(value="sendToFollowers")
    @JsonPropertyDescription(value="Send the Mails to Followers")
    private Boolean sendToFollowers = false;

    @JsonProperty(value="receivers")
    public Set<String> getReceivers() {
        return this.receivers;
    }

    @JsonProperty(value="receivers")
    public void setReceivers(Set<String> receivers) {
        this.receivers = receivers;
    }

    public EmailAlertConfig withReceivers(Set<String> receivers) {
        this.receivers = receivers;
        return this;
    }

    @JsonProperty(value="sendToAdmins")
    public Boolean getSendToAdmins() {
        return this.sendToAdmins;
    }

    @JsonProperty(value="sendToAdmins")
    public void setSendToAdmins(Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
    }

    public EmailAlertConfig withSendToAdmins(Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
        return this;
    }

    @JsonProperty(value="sendToOwners")
    public Boolean getSendToOwners() {
        return this.sendToOwners;
    }

    @JsonProperty(value="sendToOwners")
    public void setSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    public EmailAlertConfig withSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
        return this;
    }

    @JsonProperty(value="sendToFollowers")
    public Boolean getSendToFollowers() {
        return this.sendToFollowers;
    }

    @JsonProperty(value="sendToFollowers")
    public void setSendToFollowers(Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
    }

    public EmailAlertConfig withSendToFollowers(Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EmailAlertConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("receivers");
        sb.append('=');
        sb.append(this.receivers == null ? "<null>" : this.receivers);
        sb.append(',');
        sb.append("sendToAdmins");
        sb.append('=');
        sb.append(this.sendToAdmins == null ? "<null>" : this.sendToAdmins);
        sb.append(',');
        sb.append("sendToOwners");
        sb.append('=');
        sb.append(this.sendToOwners == null ? "<null>" : this.sendToOwners);
        sb.append(',');
        sb.append("sendToFollowers");
        sb.append('=');
        sb.append(this.sendToFollowers == null ? "<null>" : this.sendToFollowers);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sendToAdmins == null ? 0 : this.sendToAdmins.hashCode());
        result = result * 31 + (this.sendToOwners == null ? 0 : this.sendToOwners.hashCode());
        result = result * 31 + (this.sendToFollowers == null ? 0 : this.sendToFollowers.hashCode());
        result = result * 31 + (this.receivers == null ? 0 : this.receivers.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EmailAlertConfig)) {
            return false;
        }
        EmailAlertConfig rhs = (EmailAlertConfig)other;
        return (this.sendToAdmins == rhs.sendToAdmins || this.sendToAdmins != null && this.sendToAdmins.equals(rhs.sendToAdmins)) && (this.sendToOwners == rhs.sendToOwners || this.sendToOwners != null && this.sendToOwners.equals(rhs.sendToOwners)) && (this.sendToFollowers == rhs.sendToFollowers || this.sendToFollowers != null && this.sendToFollowers.equals(rhs.sendToFollowers)) && (this.receivers == rhs.receivers || this.receivers != null && this.receivers.equals(rhs.receivers));
    }
}

