/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entityType", "entityTier", "team", "organization", "completedDescriptions", "missingDescriptions", "hasOwner", "missingOwner", "entityCount"})
public class EntityReportData {
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="type of the entity")
    private String entityType;
    @JsonProperty(value="entityTier")
    @JsonPropertyDescription(value="Tier for the entity")
    private String entityTier;
    @JsonProperty(value="team")
    @JsonPropertyDescription(value="Team associated with the entity (i.e. owner)")
    private String team;
    @JsonProperty(value="organization")
    @JsonPropertyDescription(value="Organization associated with the entity (i.e. owner)")
    private String organization;
    @JsonProperty(value="completedDescriptions")
    @JsonPropertyDescription(value="Number of completed description for the entity")
    private Integer completedDescriptions;
    @JsonProperty(value="missingDescriptions")
    @JsonPropertyDescription(value="Number of missing description for the entity")
    private Integer missingDescriptions;
    @JsonProperty(value="hasOwner")
    @JsonPropertyDescription(value="number of entities with owner")
    private Integer hasOwner;
    @JsonProperty(value="missingOwner")
    @JsonPropertyDescription(value="number of entities missing owners")
    private Integer missingOwner;
    @JsonProperty(value="entityCount")
    @JsonPropertyDescription(value="number of entities")
    private Integer entityCount;

    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public EntityReportData withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="entityTier")
    public String getEntityTier() {
        return this.entityTier;
    }

    @JsonProperty(value="entityTier")
    public void setEntityTier(String entityTier) {
        this.entityTier = entityTier;
    }

    public EntityReportData withEntityTier(String entityTier) {
        this.entityTier = entityTier;
        return this;
    }

    @JsonProperty(value="team")
    public String getTeam() {
        return this.team;
    }

    @JsonProperty(value="team")
    public void setTeam(String team) {
        this.team = team;
    }

    public EntityReportData withTeam(String team) {
        this.team = team;
        return this;
    }

    @JsonProperty(value="organization")
    public String getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public EntityReportData withOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    @JsonProperty(value="completedDescriptions")
    public Integer getCompletedDescriptions() {
        return this.completedDescriptions;
    }

    @JsonProperty(value="completedDescriptions")
    public void setCompletedDescriptions(Integer completedDescriptions) {
        this.completedDescriptions = completedDescriptions;
    }

    public EntityReportData withCompletedDescriptions(Integer completedDescriptions) {
        this.completedDescriptions = completedDescriptions;
        return this;
    }

    @JsonProperty(value="missingDescriptions")
    public Integer getMissingDescriptions() {
        return this.missingDescriptions;
    }

    @JsonProperty(value="missingDescriptions")
    public void setMissingDescriptions(Integer missingDescriptions) {
        this.missingDescriptions = missingDescriptions;
    }

    public EntityReportData withMissingDescriptions(Integer missingDescriptions) {
        this.missingDescriptions = missingDescriptions;
        return this;
    }

    @JsonProperty(value="hasOwner")
    public Integer getHasOwner() {
        return this.hasOwner;
    }

    @JsonProperty(value="hasOwner")
    public void setHasOwner(Integer hasOwner) {
        this.hasOwner = hasOwner;
    }

    public EntityReportData withHasOwner(Integer hasOwner) {
        this.hasOwner = hasOwner;
        return this;
    }

    @JsonProperty(value="missingOwner")
    public Integer getMissingOwner() {
        return this.missingOwner;
    }

    @JsonProperty(value="missingOwner")
    public void setMissingOwner(Integer missingOwner) {
        this.missingOwner = missingOwner;
    }

    public EntityReportData withMissingOwner(Integer missingOwner) {
        this.missingOwner = missingOwner;
        return this;
    }

    @JsonProperty(value="entityCount")
    public Integer getEntityCount() {
        return this.entityCount;
    }

    @JsonProperty(value="entityCount")
    public void setEntityCount(Integer entityCount) {
        this.entityCount = entityCount;
    }

    public EntityReportData withEntityCount(Integer entityCount) {
        this.entityCount = entityCount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EntityReportData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("entityTier");
        sb.append('=');
        sb.append(this.entityTier == null ? "<null>" : this.entityTier);
        sb.append(',');
        sb.append("team");
        sb.append('=');
        sb.append(this.team == null ? "<null>" : this.team);
        sb.append(',');
        sb.append("organization");
        sb.append('=');
        sb.append(this.organization == null ? "<null>" : this.organization);
        sb.append(',');
        sb.append("completedDescriptions");
        sb.append('=');
        sb.append(this.completedDescriptions == null ? "<null>" : this.completedDescriptions);
        sb.append(',');
        sb.append("missingDescriptions");
        sb.append('=');
        sb.append(this.missingDescriptions == null ? "<null>" : this.missingDescriptions);
        sb.append(',');
        sb.append("hasOwner");
        sb.append('=');
        sb.append(this.hasOwner == null ? "<null>" : this.hasOwner);
        sb.append(',');
        sb.append("missingOwner");
        sb.append('=');
        sb.append(this.missingOwner == null ? "<null>" : this.missingOwner);
        sb.append(',');
        sb.append("entityCount");
        sb.append('=');
        sb.append(this.entityCount == null ? "<null>" : this.entityCount);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.missingDescriptions == null ? 0 : this.missingDescriptions.hashCode());
        result = result * 31 + (this.missingOwner == null ? 0 : this.missingOwner.hashCode());
        result = result * 31 + (this.entityCount == null ? 0 : this.entityCount.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.organization == null ? 0 : this.organization.hashCode());
        result = result * 31 + (this.team == null ? 0 : this.team.hashCode());
        result = result * 31 + (this.completedDescriptions == null ? 0 : this.completedDescriptions.hashCode());
        result = result * 31 + (this.hasOwner == null ? 0 : this.hasOwner.hashCode());
        result = result * 31 + (this.entityTier == null ? 0 : this.entityTier.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EntityReportData)) {
            return false;
        }
        EntityReportData rhs = (EntityReportData)other;
        return (this.missingDescriptions == rhs.missingDescriptions || this.missingDescriptions != null && this.missingDescriptions.equals(rhs.missingDescriptions)) && (this.missingOwner == rhs.missingOwner || this.missingOwner != null && this.missingOwner.equals(rhs.missingOwner)) && (this.entityCount == rhs.entityCount || this.entityCount != null && this.entityCount.equals(rhs.entityCount)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals(rhs.entityType)) && (this.organization == rhs.organization || this.organization != null && this.organization.equals(rhs.organization)) && (this.team == rhs.team || this.team != null && this.team.equals(rhs.team)) && (this.completedDescriptions == rhs.completedDescriptions || this.completedDescriptions != null && this.completedDescriptions.equals(rhs.completedDescriptions)) && (this.hasOwner == rhs.hasOwner || this.hasOwner != null && this.hasOwner.equals(rhs.hasOwner)) && (this.entityTier == rhs.entityTier || this.entityTier != null && this.entityTier.equals(rhs.entityTier));
    }
}

