/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.analytics.type.WebAnalyticEventType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"eventId", "timestamp", "eventType", "eventData"})
public class WebAnalyticEventData {
    @JsonProperty(value="eventId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID eventId;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;
    @JsonProperty(value="eventType")
    @JsonPropertyDescription(value="event type")
    @NotNull
    private WebAnalyticEventType eventType;
    @JsonProperty(value="eventData")
    @JsonPropertyDescription(value="Web analytic data captured")
    private Object eventData;

    @JsonProperty(value="eventId")
    public UUID getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    public void setEventId(UUID eventId) {
        this.eventId = eventId;
    }

    public WebAnalyticEventData withEventId(UUID eventId) {
        this.eventId = eventId;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public WebAnalyticEventData withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="eventType")
    public WebAnalyticEventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    public void setEventType(WebAnalyticEventType eventType) {
        this.eventType = eventType;
    }

    public WebAnalyticEventData withEventType(WebAnalyticEventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @JsonProperty(value="eventData")
    public Object getEventData() {
        return this.eventData;
    }

    @JsonProperty(value="eventData")
    public void setEventData(Object eventData) {
        this.eventData = eventData;
    }

    public WebAnalyticEventData withEventData(Object eventData) {
        this.eventData = eventData;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WebAnalyticEventData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("eventId");
        sb.append('=');
        sb.append(this.eventId == null ? "<null>" : this.eventId);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        sb.append("eventData");
        sb.append('=');
        sb.append(this.eventData == null ? "<null>" : this.eventData);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = result * 31 + (this.eventData == null ? 0 : this.eventData.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WebAnalyticEventData)) {
            return false;
        }
        WebAnalyticEventData rhs = (WebAnalyticEventData)other;
        return (this.eventId == rhs.eventId || this.eventId != null && this.eventId.equals(rhs.eventId)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals((Object)rhs.eventType)) && (this.eventData == rhs.eventData || this.eventData != null && this.eventData.equals(rhs.eventData)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

