/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.analytics.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum WebAnalyticEventType {
    PAGE_VIEW("PageView"),
    CUSTOM_EVENT("CustomEvent");

    private final String value;
    private static final Map<String, WebAnalyticEventType> CONSTANTS;

    private WebAnalyticEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static WebAnalyticEventType fromValue(String value) {
        WebAnalyticEventType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, WebAnalyticEventType>();
        for (WebAnalyticEventType c : WebAnalyticEventType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

