/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.ContainerDataModel;
import org.openmetadata.schema.type.ContainerFileFormat;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "service", "parent", "dataModel", "prefix", "numberOfObjects", "size", "fileFormats", "owner", "tags", "extension"})
public class CreateContainer
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Container model.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String service;
    @JsonProperty(value="parent")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference parent;
    @JsonProperty(value="dataModel")
    @JsonPropertyDescription(value="This captures information about how the container's data is modeled, if it has a schema. ")
    @Valid
    private ContainerDataModel dataModel;
    @JsonProperty(value="prefix")
    @JsonPropertyDescription(value="Optional prefix path defined for this container")
    private String prefix = null;
    @JsonProperty(value="numberOfObjects")
    @JsonPropertyDescription(value="The number of objects/files this container has.")
    private Double numberOfObjects = null;
    @JsonProperty(value="size")
    @JsonPropertyDescription(value="The total size in KB this container has.")
    private Double size = null;
    @JsonProperty(value="fileFormats")
    @JsonPropertyDescription(value="File & data formats identified for the container:  e.g. dataFormats=[csv, json]. These can be present both when the container has a dataModel or not")
    @Valid
    private List<ContainerFileFormat> fileFormats = null;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this Container Model")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateContainer withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateContainer withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateContainer withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateContainer withService(String service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="parent")
    public EntityReference getParent() {
        return this.parent;
    }

    @JsonProperty(value="parent")
    public void setParent(EntityReference parent) {
        this.parent = parent;
    }

    public CreateContainer withParent(EntityReference parent) {
        this.parent = parent;
        return this;
    }

    @JsonProperty(value="dataModel")
    public ContainerDataModel getDataModel() {
        return this.dataModel;
    }

    @JsonProperty(value="dataModel")
    public void setDataModel(ContainerDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public CreateContainer withDataModel(ContainerDataModel dataModel) {
        this.dataModel = dataModel;
        return this;
    }

    @JsonProperty(value="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty(value="prefix")
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public CreateContainer withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @JsonProperty(value="numberOfObjects")
    public Double getNumberOfObjects() {
        return this.numberOfObjects;
    }

    @JsonProperty(value="numberOfObjects")
    public void setNumberOfObjects(Double numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    public CreateContainer withNumberOfObjects(Double numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
        return this;
    }

    @JsonProperty(value="size")
    public Double getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    public void setSize(Double size) {
        this.size = size;
    }

    public CreateContainer withSize(Double size) {
        this.size = size;
        return this;
    }

    @JsonProperty(value="fileFormats")
    public List<ContainerFileFormat> getFileFormats() {
        return this.fileFormats;
    }

    @JsonProperty(value="fileFormats")
    public void setFileFormats(List<ContainerFileFormat> fileFormats) {
        this.fileFormats = fileFormats;
    }

    public CreateContainer withFileFormats(List<ContainerFileFormat> fileFormats) {
        this.fileFormats = fileFormats;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateContainer withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateContainer withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateContainer withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateContainer.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(this.parent == null ? "<null>" : this.parent);
        sb.append(',');
        sb.append("dataModel");
        sb.append('=');
        sb.append(this.dataModel == null ? "<null>" : this.dataModel);
        sb.append(',');
        sb.append("prefix");
        sb.append('=');
        sb.append(this.prefix == null ? "<null>" : this.prefix);
        sb.append(',');
        sb.append("numberOfObjects");
        sb.append('=');
        sb.append(this.numberOfObjects == null ? "<null>" : this.numberOfObjects);
        sb.append(',');
        sb.append("size");
        sb.append('=');
        sb.append(this.size == null ? "<null>" : this.size);
        sb.append(',');
        sb.append("fileFormats");
        sb.append('=');
        sb.append(this.fileFormats == null ? "<null>" : this.fileFormats);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.parent == null ? 0 : this.parent.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = result * 31 + (this.dataModel == null ? 0 : this.dataModel.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fileFormats == null ? 0 : this.fileFormats.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.size == null ? 0 : this.size.hashCode());
        result = result * 31 + (this.numberOfObjects == null ? 0 : this.numberOfObjects.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateContainer)) {
            return false;
        }
        CreateContainer rhs = (CreateContainer)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.parent == rhs.parent || this.parent != null && this.parent.equals(rhs.parent)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.prefix == rhs.prefix || this.prefix != null && this.prefix.equals(rhs.prefix)) && (this.dataModel == rhs.dataModel || this.dataModel != null && this.dataModel.equals(rhs.dataModel)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fileFormats == rhs.fileFormats || this.fileFormats != null && this.fileFormats.equals(rhs.fileFormats)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.size == rhs.size || this.size != null && this.size.equals(rhs.size)) && (this.numberOfObjects == rhs.numberOfObjects || this.numberOfObjects != null && this.numberOfObjects.equals(rhs.numberOfObjects)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name));
    }
}

