/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "dashboardUrl", "charts", "dataModels", "tags", "owner", "service", "extension"})
public class CreateDashboard
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Dashboard. It could be title or label from the source services")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="dashboardUrl")
    @JsonPropertyDescription(value="Dashboard URL suffix from its service.")
    private String dashboardUrl;
    @JsonProperty(value="charts")
    @JsonPropertyDescription(value="List of fully qualified name of charts included in this Dashboard.")
    @Valid
    private List<String> charts = null;
    @JsonProperty(value="dataModels")
    @JsonPropertyDescription(value="List of fully qualified name of data models included in this Dashboard.")
    @Valid
    private List<String> dataModels = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this dashboard")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String service;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateDashboard withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateDashboard withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDashboard withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="dashboardUrl")
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @JsonProperty(value="dashboardUrl")
    public void setDashboardUrl(String dashboardUrl) {
        this.dashboardUrl = dashboardUrl;
    }

    public CreateDashboard withDashboardUrl(String dashboardUrl) {
        this.dashboardUrl = dashboardUrl;
        return this;
    }

    @JsonProperty(value="charts")
    public List<String> getCharts() {
        return this.charts;
    }

    @JsonProperty(value="charts")
    public void setCharts(List<String> charts) {
        this.charts = charts;
    }

    public CreateDashboard withCharts(List<String> charts) {
        this.charts = charts;
        return this;
    }

    @JsonProperty(value="dataModels")
    public List<String> getDataModels() {
        return this.dataModels;
    }

    @JsonProperty(value="dataModels")
    public void setDataModels(List<String> dataModels) {
        this.dataModels = dataModels;
    }

    public CreateDashboard withDataModels(List<String> dataModels) {
        this.dataModels = dataModels;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateDashboard withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateDashboard withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateDashboard withService(String service) {
        this.service = service;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateDashboard withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateDashboard.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("dashboardUrl");
        sb.append('=');
        sb.append(this.dashboardUrl == null ? "<null>" : this.dashboardUrl);
        sb.append(',');
        sb.append("charts");
        sb.append('=');
        sb.append(this.charts == null ? "<null>" : this.charts);
        sb.append(',');
        sb.append("dataModels");
        sb.append('=');
        sb.append(this.dataModels == null ? "<null>" : this.dataModels);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.dashboardUrl == null ? 0 : this.dashboardUrl.hashCode());
        result = result * 31 + (this.charts == null ? 0 : this.charts.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.dataModels == null ? 0 : this.dataModels.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateDashboard)) {
            return false;
        }
        CreateDashboard rhs = (CreateDashboard)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.dashboardUrl == rhs.dashboardUrl || this.dashboardUrl != null && this.dashboardUrl.equals(rhs.dashboardUrl)) && (this.charts == rhs.charts || this.charts != null && this.charts.equals(rhs.charts)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.dataModels == rhs.dataModels || this.dataModels != null && this.dataModels.equals(rhs.dataModels)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

