/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.EnumInterface;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.DataModelType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "tags", "owner", "service", "serviceType", "dataModelType", "sql", "columns"})
public class CreateDashboardDataModel
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this data model. It could be title or label from the source services.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this data model.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String service;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of Dashboard service - Superset, Looker, Redash, Tableau, Metabase, PowerBi or Mode")
    private DashboardServiceType serviceType;
    @JsonProperty(value="dataModelType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of data models.")
    private DataModelType dataModelType;
    @JsonProperty(value="sql")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String sql;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Columns from the data model.")
    @Valid
    private List<Column> columns = null;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateDashboardDataModel withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateDashboardDataModel withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDashboardDataModel withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateDashboardDataModel withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateDashboardDataModel withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="service")
    public String getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(String service) {
        this.service = service;
    }

    public CreateDashboardDataModel withService(String service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="serviceType")
    public DashboardServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(DashboardServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public CreateDashboardDataModel withServiceType(DashboardServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="dataModelType")
    public DataModelType getDataModelType() {
        return this.dataModelType;
    }

    @JsonProperty(value="dataModelType")
    public void setDataModelType(DataModelType dataModelType) {
        this.dataModelType = dataModelType;
    }

    public CreateDashboardDataModel withDataModelType(DataModelType dataModelType) {
        this.dataModelType = dataModelType;
        return this;
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="sql")
    public void setSql(String sql) {
        this.sql = sql;
    }

    public CreateDashboardDataModel withSql(String sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public CreateDashboardDataModel withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateDashboardDataModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("dataModelType");
        sb.append('=');
        sb.append(this.dataModelType == null ? "<null>" : this.dataModelType);
        sb.append(',');
        sb.append("sql");
        sb.append('=');
        sb.append(this.sql == null ? "<null>" : this.sql);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.dataModelType == null ? 0 : this.dataModelType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sql == null ? 0 : this.sql.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateDashboardDataModel)) {
            return false;
        }
        CreateDashboardDataModel rhs = (CreateDashboardDataModel)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.dataModelType == rhs.dataModelType || this.dataModelType != null && this.dataModelType.equals((Object)rhs.dataModelType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sql == rhs.sql || this.sql != null && this.sql.equals(rhs.sql));
    }

    public static enum DashboardServiceType implements EnumInterface
    {
        Superset("Superset"),
        Looker("Looker"),
        Tableau("Tableau"),
        Redash("Redash"),
        Metabase("Metabase"),
        PowerBI("PowerBI"),
        Mode("Mode"),
        CustomDashboard("CustomDashboard"),
        DomoDashboard("DomoDashboard"),
        QuickSight("QuickSight");

        private final String value;
        private static final Map<String, DashboardServiceType> CONSTANTS;

        private DashboardServiceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DashboardServiceType fromValue(String value) {
            DashboardServiceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DashboardServiceType>();
            for (DashboardServiceType c : DashboardServiceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

