/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owner", "tags", "query", "duration", "users", "queryDate", "queryUsedIn"})
public class CreateQuery
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this query.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this Query")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="query")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    @NotNull
    private String query;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="How long did the query took to run in seconds.")
    private Double duration;
    @JsonProperty(value="users")
    @JsonPropertyDescription(value="UserName of the user running the query.")
    @Valid
    private List<String> users = new ArrayList<String>();
    @JsonProperty(value="queryDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long queryDate;
    @JsonProperty(value="queryUsedIn")
    @Valid
    private List<EntityReference> queryUsedIn = null;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateQuery withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateQuery withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateQuery withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateQuery withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateQuery withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    public CreateQuery withQuery(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="duration")
    public Double getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public CreateQuery withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="users")
    public List<String> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<String> users) {
        this.users = users;
    }

    public CreateQuery withUsers(List<String> users) {
        this.users = users;
        return this;
    }

    @JsonProperty(value="queryDate")
    public Long getQueryDate() {
        return this.queryDate;
    }

    @JsonProperty(value="queryDate")
    public void setQueryDate(Long queryDate) {
        this.queryDate = queryDate;
    }

    public CreateQuery withQueryDate(Long queryDate) {
        this.queryDate = queryDate;
        return this;
    }

    @JsonProperty(value="queryUsedIn")
    public List<EntityReference> getQueryUsedIn() {
        return this.queryUsedIn;
    }

    @JsonProperty(value="queryUsedIn")
    public void setQueryUsedIn(List<EntityReference> queryUsedIn) {
        this.queryUsedIn = queryUsedIn;
    }

    public CreateQuery withQueryUsedIn(List<EntityReference> queryUsedIn) {
        this.queryUsedIn = queryUsedIn;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateQuery.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("query");
        sb.append('=');
        sb.append(this.query == null ? "<null>" : this.query);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(this.users == null ? "<null>" : this.users);
        sb.append(',');
        sb.append("queryDate");
        sb.append('=');
        sb.append(this.queryDate == null ? "<null>" : this.queryDate);
        sb.append(',');
        sb.append("queryUsedIn");
        sb.append('=');
        sb.append(this.queryUsedIn == null ? "<null>" : this.queryUsedIn);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.queryUsedIn == null ? 0 : this.queryUsedIn.hashCode());
        result = result * 31 + (this.queryDate == null ? 0 : this.queryDate.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.query == null ? 0 : this.query.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.users == null ? 0 : this.users.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateQuery)) {
            return false;
        }
        CreateQuery rhs = (CreateQuery)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.queryUsedIn == rhs.queryUsedIn || this.queryUsedIn != null && this.queryUsedIn.equals(rhs.queryUsedIn)) && (this.queryDate == rhs.queryDate || this.queryDate != null && this.queryDate.equals(rhs.queryDate)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.query == rhs.query || this.query != null && this.query.equals(rhs.query)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.users == rhs.users || this.users != null && this.users.equals(rhs.users)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

