/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TableConstraint;
import org.openmetadata.schema.type.TablePartition;
import org.openmetadata.schema.type.TableProfilerConfig;
import org.openmetadata.schema.type.TableType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "tableType", "columns", "tableConstraints", "tablePartition", "tableProfilerConfig", "owner", "databaseSchema", "tags", "viewDefinition", "extension"})
public class CreateTable
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of a table. Expected to be unique within a database.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this table.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="tableType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of tables.")
    private TableType tableType;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Name of the tables in the database")
    @Valid
    @NotNull
    private List<Column> columns = null;
    @JsonProperty(value="tableConstraints")
    @Valid
    private List<TableConstraint> tableConstraints = null;
    @JsonProperty(value="tablePartition")
    @JsonPropertyDescription(value="This schema defines the partition column of a table and format the partition is created.")
    @Valid
    private TablePartition tablePartition;
    @JsonProperty(value="tableProfilerConfig")
    @JsonPropertyDescription(value="This schema defines the type for Table profile config.")
    @Valid
    private TableProfilerConfig tableProfilerConfig;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String databaseSchema;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this table")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="viewDefinition")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String viewDefinition;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateTable withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTable withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTable withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="tableType")
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="tableType")
    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public CreateTable withTableType(TableType tableType) {
        this.tableType = tableType;
        return this;
    }

    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public CreateTable withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="tableConstraints")
    public List<TableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    @JsonProperty(value="tableConstraints")
    public void setTableConstraints(List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
    }

    public CreateTable withTableConstraints(List<TableConstraint> tableConstraints) {
        this.tableConstraints = tableConstraints;
        return this;
    }

    @JsonProperty(value="tablePartition")
    public TablePartition getTablePartition() {
        return this.tablePartition;
    }

    @JsonProperty(value="tablePartition")
    public void setTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    public CreateTable withTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
        return this;
    }

    @JsonProperty(value="tableProfilerConfig")
    public TableProfilerConfig getTableProfilerConfig() {
        return this.tableProfilerConfig;
    }

    @JsonProperty(value="tableProfilerConfig")
    public void setTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
    }

    public CreateTable withTableProfilerConfig(TableProfilerConfig tableProfilerConfig) {
        this.tableProfilerConfig = tableProfilerConfig;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateTable withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public CreateTable withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateTable withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="viewDefinition")
    public String getViewDefinition() {
        return this.viewDefinition;
    }

    @JsonProperty(value="viewDefinition")
    public void setViewDefinition(String viewDefinition) {
        this.viewDefinition = viewDefinition;
    }

    public CreateTable withViewDefinition(String viewDefinition) {
        this.viewDefinition = viewDefinition;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateTable withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTable.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tableType");
        sb.append('=');
        sb.append(this.tableType == null ? "<null>" : this.tableType);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("tableConstraints");
        sb.append('=');
        sb.append(this.tableConstraints == null ? "<null>" : this.tableConstraints);
        sb.append(',');
        sb.append("tablePartition");
        sb.append('=');
        sb.append(this.tablePartition == null ? "<null>" : this.tablePartition);
        sb.append(',');
        sb.append("tableProfilerConfig");
        sb.append('=');
        sb.append(this.tableProfilerConfig == null ? "<null>" : this.tableProfilerConfig);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("viewDefinition");
        sb.append('=');
        sb.append(this.viewDefinition == null ? "<null>" : this.viewDefinition);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.viewDefinition == null ? 0 : this.viewDefinition.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.tableConstraints == null ? 0 : this.tableConstraints.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.tableType == null ? 0 : this.tableType.hashCode());
        result = result * 31 + (this.tableProfilerConfig == null ? 0 : this.tableProfilerConfig.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.tablePartition == null ? 0 : this.tablePartition.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTable)) {
            return false;
        }
        CreateTable rhs = (CreateTable)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.viewDefinition == rhs.viewDefinition || this.viewDefinition != null && this.viewDefinition.equals(rhs.viewDefinition)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.tableConstraints == rhs.tableConstraints || this.tableConstraints != null && this.tableConstraints.equals(rhs.tableConstraints)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.tableType == rhs.tableType || this.tableType != null && this.tableType.equals((Object)rhs.tableType)) && (this.tableProfilerConfig == rhs.tableProfilerConfig || this.tableProfilerConfig != null && this.tableProfilerConfig.equals(rhs.tableProfilerConfig)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.tablePartition == rhs.tablePartition || this.tablePartition != null && this.tablePartition.equals(rhs.tablePartition));
    }
}

