/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.dataInsight.kpi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.dataInsight.type.KpiTargetType;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owner", "dataInsightChart", "startDate", "endDate", "targetDefinition", "metricType"})
public class CreateKpiRequest
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Kpi.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="dataInsightChart")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String dataInsightChart;
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long startDate;
    @JsonProperty(value="endDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long endDate;
    @JsonProperty(value="targetDefinition")
    @JsonPropertyDescription(value="Metrics from the chart and the target to achieve the result.")
    @Valid
    @NotNull
    private List<KpiTarget> targetDefinition = new ArrayList<KpiTarget>();
    @JsonProperty(value="metricType")
    @JsonPropertyDescription(value="This enum defines the type of key Result")
    @NotNull
    private KpiTargetType metricType;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateKpiRequest withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateKpiRequest withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateKpiRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateKpiRequest withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="dataInsightChart")
    public String getDataInsightChart() {
        return this.dataInsightChart;
    }

    @JsonProperty(value="dataInsightChart")
    public void setDataInsightChart(String dataInsightChart) {
        this.dataInsightChart = dataInsightChart;
    }

    public CreateKpiRequest withDataInsightChart(String dataInsightChart) {
        this.dataInsightChart = dataInsightChart;
        return this;
    }

    @JsonProperty(value="startDate")
    public Long getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public CreateKpiRequest withStartDate(Long startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="endDate")
    public Long getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public CreateKpiRequest withEndDate(Long endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty(value="targetDefinition")
    public List<KpiTarget> getTargetDefinition() {
        return this.targetDefinition;
    }

    @JsonProperty(value="targetDefinition")
    public void setTargetDefinition(List<KpiTarget> targetDefinition) {
        this.targetDefinition = targetDefinition;
    }

    public CreateKpiRequest withTargetDefinition(List<KpiTarget> targetDefinition) {
        this.targetDefinition = targetDefinition;
        return this;
    }

    @JsonProperty(value="metricType")
    public KpiTargetType getMetricType() {
        return this.metricType;
    }

    @JsonProperty(value="metricType")
    public void setMetricType(KpiTargetType metricType) {
        this.metricType = metricType;
    }

    public CreateKpiRequest withMetricType(KpiTargetType metricType) {
        this.metricType = metricType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateKpiRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("dataInsightChart");
        sb.append('=');
        sb.append(this.dataInsightChart == null ? "<null>" : this.dataInsightChart);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("targetDefinition");
        sb.append('=');
        sb.append(this.targetDefinition == null ? "<null>" : this.targetDefinition);
        sb.append(',');
        sb.append("metricType");
        sb.append('=');
        sb.append(this.metricType == null ? "<null>" : this.metricType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.metricType == null ? 0 : this.metricType.hashCode());
        result = result * 31 + (this.dataInsightChart == null ? 0 : this.dataInsightChart.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.targetDefinition == null ? 0 : this.targetDefinition.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateKpiRequest)) {
            return false;
        }
        CreateKpiRequest rhs = (CreateKpiRequest)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.metricType == rhs.metricType || this.metricType != null && this.metricType.equals((Object)rhs.metricType)) && (this.dataInsightChart == rhs.dataInsightChart || this.dataInsightChart != null && this.dataInsightChart.equals(rhs.dataInsightChart)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.targetDefinition == rhs.targetDefinition || this.targetDefinition != null && this.targetDefinition.equals(rhs.targetDefinition)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }
}

