/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.entity.events.FilteringRules;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "owner", "enabled", "batchSize", "timeout", "readTimeout", "filteringRules", "subscriptionType", "subscriptionConfig"})
public class CreateEventSubscription
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display name for this Alert.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is the alert enabled.")
    private Boolean enabled = true;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 10).")
    private Integer batchSize = 10;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Connection timeout in seconds. (Default 10s).")
    private Integer timeout = 10;
    @JsonProperty(value="readTimeout")
    @JsonPropertyDescription(value="Read timeout in seconds. (Default 12s).")
    private Integer readTimeout = 12;
    @JsonProperty(value="filteringRules")
    @JsonPropertyDescription(value="Filtering Rules for Event Subscription.")
    @Valid
    @NotNull
    private FilteringRules filteringRules;
    @JsonProperty(value="subscriptionType")
    @JsonPropertyDescription(value="Subscription Endpoint Type")
    @NotNull
    private SubscriptionType subscriptionType;
    @JsonProperty(value="subscriptionConfig")
    @NotNull
    private Object subscriptionConfig;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateEventSubscription withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateEventSubscription withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateEventSubscription withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateEventSubscription withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CreateEventSubscription withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public CreateEventSubscription withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public CreateEventSubscription withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty(value="readTimeout")
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @JsonProperty(value="readTimeout")
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public CreateEventSubscription withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @JsonProperty(value="filteringRules")
    public FilteringRules getFilteringRules() {
        return this.filteringRules;
    }

    @JsonProperty(value="filteringRules")
    public void setFilteringRules(FilteringRules filteringRules) {
        this.filteringRules = filteringRules;
    }

    public CreateEventSubscription withFilteringRules(FilteringRules filteringRules) {
        this.filteringRules = filteringRules;
        return this;
    }

    @JsonProperty(value="subscriptionType")
    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    @JsonProperty(value="subscriptionType")
    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public CreateEventSubscription withSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this;
    }

    @JsonProperty(value="subscriptionConfig")
    public Object getSubscriptionConfig() {
        return this.subscriptionConfig;
    }

    @JsonProperty(value="subscriptionConfig")
    public void setSubscriptionConfig(Object subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
    }

    public CreateEventSubscription withSubscriptionConfig(Object subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateEventSubscription.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("timeout");
        sb.append('=');
        sb.append(this.timeout == null ? "<null>" : this.timeout);
        sb.append(',');
        sb.append("readTimeout");
        sb.append('=');
        sb.append(this.readTimeout == null ? "<null>" : this.readTimeout);
        sb.append(',');
        sb.append("filteringRules");
        sb.append('=');
        sb.append(this.filteringRules == null ? "<null>" : this.filteringRules);
        sb.append(',');
        sb.append("subscriptionType");
        sb.append('=');
        sb.append(this.subscriptionType == null ? "<null>" : this.subscriptionType);
        sb.append(',');
        sb.append("subscriptionConfig");
        sb.append('=');
        sb.append(this.subscriptionConfig == null ? "<null>" : this.subscriptionConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.filteringRules == null ? 0 : this.filteringRules.hashCode());
        result = result * 31 + (this.subscriptionType == null ? 0 : this.subscriptionType.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.readTimeout == null ? 0 : this.readTimeout.hashCode());
        result = result * 31 + (this.subscriptionConfig == null ? 0 : this.subscriptionConfig.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.timeout == null ? 0 : this.timeout.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateEventSubscription)) {
            return false;
        }
        CreateEventSubscription rhs = (CreateEventSubscription)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.filteringRules == rhs.filteringRules || this.filteringRules != null && this.filteringRules.equals(rhs.filteringRules)) && (this.subscriptionType == rhs.subscriptionType || this.subscriptionType != null && this.subscriptionType.equals((Object)rhs.subscriptionType)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.readTimeout == rhs.readTimeout || this.readTimeout != null && this.readTimeout.equals(rhs.readTimeout)) && (this.subscriptionConfig == rhs.subscriptionConfig || this.subscriptionConfig != null && this.subscriptionConfig.equals(rhs.subscriptionConfig)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.timeout == rhs.timeout || this.timeout != null && this.timeout.equals(rhs.timeout));
    }

    public static enum SubscriptionType {
        GENERIC_WEBHOOK("GenericWebhook"),
        SLACK_WEBHOOK("SlackWebhook"),
        MS_TEAMS_WEBHOOK("MsTeamsWebhook"),
        G_CHAT_WEBHOOK("GChatWebhook"),
        EMAIL("Email"),
        ACTIVITY_FEED("ActivityFeed");

        private final String value;
        private static final Map<String, SubscriptionType> CONSTANTS;

        private SubscriptionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SubscriptionType fromValue(String value) {
            SubscriptionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SubscriptionType>();
            for (SubscriptionType c : SubscriptionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

