/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.feed;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.openmetadata.schema.api.CreateTaskDetails;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.ThreadType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"message", "from", "addressedTo", "about", "type", "taskDetails", "announcementDetails"})
public class CreateThread {
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Message")
    @NotNull
    private String message;
    @JsonProperty(value="from")
    @JsonPropertyDescription(value="Name of the User (regular user or bot) posting the message")
    @NotNull
    private String from;
    @JsonProperty(value="addressedTo")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$")
    private @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$") String addressedTo;
    @JsonProperty(value="about")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$")
    @NotNull
    private @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$") @NotNull String about;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of thread.")
    private ThreadType type = ThreadType.fromValue("Conversation");
    @JsonProperty(value="taskDetails")
    @JsonPropertyDescription(value="Details about the task. This is only applicable if thread is of type task.")
    @Valid
    private CreateTaskDetails taskDetails;
    @JsonProperty(value="announcementDetails")
    @JsonPropertyDescription(value="Details about the announcement. This is only applicable if thread is of type announcement.")
    @Valid
    private AnnouncementDetails announcementDetails;

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public CreateThread withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    public CreateThread withFrom(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="addressedTo")
    public String getAddressedTo() {
        return this.addressedTo;
    }

    @JsonProperty(value="addressedTo")
    public void setAddressedTo(String addressedTo) {
        this.addressedTo = addressedTo;
    }

    public CreateThread withAddressedTo(String addressedTo) {
        this.addressedTo = addressedTo;
        return this;
    }

    @JsonProperty(value="about")
    public String getAbout() {
        return this.about;
    }

    @JsonProperty(value="about")
    public void setAbout(String about) {
        this.about = about;
    }

    public CreateThread withAbout(String about) {
        this.about = about;
        return this;
    }

    @JsonProperty(value="type")
    public ThreadType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ThreadType type) {
        this.type = type;
    }

    public CreateThread withType(ThreadType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="taskDetails")
    public CreateTaskDetails getTaskDetails() {
        return this.taskDetails;
    }

    @JsonProperty(value="taskDetails")
    public void setTaskDetails(CreateTaskDetails taskDetails) {
        this.taskDetails = taskDetails;
    }

    public CreateThread withTaskDetails(CreateTaskDetails taskDetails) {
        this.taskDetails = taskDetails;
        return this;
    }

    @JsonProperty(value="announcementDetails")
    public AnnouncementDetails getAnnouncementDetails() {
        return this.announcementDetails;
    }

    @JsonProperty(value="announcementDetails")
    public void setAnnouncementDetails(AnnouncementDetails announcementDetails) {
        this.announcementDetails = announcementDetails;
    }

    public CreateThread withAnnouncementDetails(AnnouncementDetails announcementDetails) {
        this.announcementDetails = announcementDetails;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateThread.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("from");
        sb.append('=');
        sb.append(this.from == null ? "<null>" : this.from);
        sb.append(',');
        sb.append("addressedTo");
        sb.append('=');
        sb.append(this.addressedTo == null ? "<null>" : this.addressedTo);
        sb.append(',');
        sb.append("about");
        sb.append('=');
        sb.append(this.about == null ? "<null>" : this.about);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("taskDetails");
        sb.append('=');
        sb.append(this.taskDetails == null ? "<null>" : this.taskDetails);
        sb.append(',');
        sb.append("announcementDetails");
        sb.append('=');
        sb.append(this.announcementDetails == null ? "<null>" : this.announcementDetails);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.addressedTo == null ? 0 : this.addressedTo.hashCode());
        result = result * 31 + (this.announcementDetails == null ? 0 : this.announcementDetails.hashCode());
        result = result * 31 + (this.about == null ? 0 : this.about.hashCode());
        result = result * 31 + (this.from == null ? 0 : this.from.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.taskDetails == null ? 0 : this.taskDetails.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateThread)) {
            return false;
        }
        CreateThread rhs = (CreateThread)other;
        return (this.addressedTo == rhs.addressedTo || this.addressedTo != null && this.addressedTo.equals(rhs.addressedTo)) && (this.announcementDetails == rhs.announcementDetails || this.announcementDetails != null && this.announcementDetails.equals(rhs.announcementDetails)) && (this.about == rhs.about || this.about != null && this.about.equals(rhs.about)) && (this.from == rhs.from || this.from != null && this.from.equals(rhs.from)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.taskDetails == rhs.taskDetails || this.taskDetails != null && this.taskDetails.equals(rhs.taskDetails));
    }
}

