/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.security;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.catalog.security.client.SamlSSOClientConfig;
import org.openmetadata.schema.auth.LdapConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"provider", "providerName", "publicKeyUrls", "authority", "clientId", "callbackUrl", "jwtPrincipalClaims", "enableSelfSignup", "ldapConfiguration", "samlConfiguration"})
public class AuthenticationConfiguration {
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="SSO provider: no-auth, okta, google, azure, auth0, custom-oidc, aws-cognito, ldap, saml, etc.")
    @NotNull
    private String provider;
    @JsonProperty(value="providerName")
    @JsonPropertyDescription(value="Custom OIDC Authentication Provider Name")
    @NotNull
    private String providerName;
    @JsonProperty(value="publicKeyUrls")
    @JsonPropertyDescription(value="List of Public Key URLs")
    @Valid
    @NotNull
    private List<String> publicKeyUrls = new ArrayList<String>();
    @JsonProperty(value="authority")
    @JsonPropertyDescription(value="Authentication Authority")
    @NotNull
    private String authority;
    @JsonProperty(value="clientId")
    @JsonPropertyDescription(value="Client ID")
    @NotNull
    private String clientId;
    @JsonProperty(value="callbackUrl")
    @JsonPropertyDescription(value="Callback URL")
    @NotNull
    private String callbackUrl;
    @JsonProperty(value="jwtPrincipalClaims")
    @JsonPropertyDescription(value="Jwt Principal Claim")
    @Valid
    @NotNull
    private List<String> jwtPrincipalClaims = new ArrayList<String>();
    @JsonProperty(value="enableSelfSignup")
    @JsonPropertyDescription(value="Enable Self Sign Up")
    private Boolean enableSelfSignup = false;
    @JsonProperty(value="ldapConfiguration")
    @JsonPropertyDescription(value="LDAP Configuration")
    @Valid
    private LdapConfiguration ldapConfiguration;
    @JsonProperty(value="samlConfiguration")
    @JsonPropertyDescription(value="SAML SSO client security configs.")
    @Valid
    private SamlSSOClientConfig samlConfiguration;

    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public AuthenticationConfiguration withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="providerName")
    public String getProviderName() {
        return this.providerName;
    }

    @JsonProperty(value="providerName")
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public AuthenticationConfiguration withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    @JsonProperty(value="publicKeyUrls")
    public List<String> getPublicKeyUrls() {
        return this.publicKeyUrls;
    }

    @JsonProperty(value="publicKeyUrls")
    public void setPublicKeyUrls(List<String> publicKeyUrls) {
        this.publicKeyUrls = publicKeyUrls;
    }

    public AuthenticationConfiguration withPublicKeyUrls(List<String> publicKeyUrls) {
        this.publicKeyUrls = publicKeyUrls;
        return this;
    }

    @JsonProperty(value="authority")
    public String getAuthority() {
        return this.authority;
    }

    @JsonProperty(value="authority")
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public AuthenticationConfiguration withAuthority(String authority) {
        this.authority = authority;
        return this;
    }

    @JsonProperty(value="clientId")
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public AuthenticationConfiguration withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @JsonProperty(value="callbackUrl")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @JsonProperty(value="callbackUrl")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public AuthenticationConfiguration withCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @JsonProperty(value="jwtPrincipalClaims")
    public List<String> getJwtPrincipalClaims() {
        return this.jwtPrincipalClaims;
    }

    @JsonProperty(value="jwtPrincipalClaims")
    public void setJwtPrincipalClaims(List<String> jwtPrincipalClaims) {
        this.jwtPrincipalClaims = jwtPrincipalClaims;
    }

    public AuthenticationConfiguration withJwtPrincipalClaims(List<String> jwtPrincipalClaims) {
        this.jwtPrincipalClaims = jwtPrincipalClaims;
        return this;
    }

    @JsonProperty(value="enableSelfSignup")
    public Boolean getEnableSelfSignup() {
        return this.enableSelfSignup;
    }

    @JsonProperty(value="enableSelfSignup")
    public void setEnableSelfSignup(Boolean enableSelfSignup) {
        this.enableSelfSignup = enableSelfSignup;
    }

    public AuthenticationConfiguration withEnableSelfSignup(Boolean enableSelfSignup) {
        this.enableSelfSignup = enableSelfSignup;
        return this;
    }

    @JsonProperty(value="ldapConfiguration")
    public LdapConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    @JsonProperty(value="ldapConfiguration")
    public void setLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public AuthenticationConfiguration withLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
        return this;
    }

    @JsonProperty(value="samlConfiguration")
    public SamlSSOClientConfig getSamlConfiguration() {
        return this.samlConfiguration;
    }

    @JsonProperty(value="samlConfiguration")
    public void setSamlConfiguration(SamlSSOClientConfig samlConfiguration) {
        this.samlConfiguration = samlConfiguration;
    }

    public AuthenticationConfiguration withSamlConfiguration(SamlSSOClientConfig samlConfiguration) {
        this.samlConfiguration = samlConfiguration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthenticationConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("providerName");
        sb.append('=');
        sb.append(this.providerName == null ? "<null>" : this.providerName);
        sb.append(',');
        sb.append("publicKeyUrls");
        sb.append('=');
        sb.append(this.publicKeyUrls == null ? "<null>" : this.publicKeyUrls);
        sb.append(',');
        sb.append("authority");
        sb.append('=');
        sb.append(this.authority == null ? "<null>" : this.authority);
        sb.append(',');
        sb.append("clientId");
        sb.append('=');
        sb.append(this.clientId == null ? "<null>" : this.clientId);
        sb.append(',');
        sb.append("callbackUrl");
        sb.append('=');
        sb.append(this.callbackUrl == null ? "<null>" : this.callbackUrl);
        sb.append(',');
        sb.append("jwtPrincipalClaims");
        sb.append('=');
        sb.append(this.jwtPrincipalClaims == null ? "<null>" : this.jwtPrincipalClaims);
        sb.append(',');
        sb.append("enableSelfSignup");
        sb.append('=');
        sb.append(this.enableSelfSignup == null ? "<null>" : this.enableSelfSignup);
        sb.append(',');
        sb.append("ldapConfiguration");
        sb.append('=');
        sb.append(this.ldapConfiguration == null ? "<null>" : this.ldapConfiguration);
        sb.append(',');
        sb.append("samlConfiguration");
        sb.append('=');
        sb.append(this.samlConfiguration == null ? "<null>" : this.samlConfiguration);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.enableSelfSignup == null ? 0 : this.enableSelfSignup.hashCode());
        result = result * 31 + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.publicKeyUrls == null ? 0 : this.publicKeyUrls.hashCode());
        result = result * 31 + (this.authority == null ? 0 : this.authority.hashCode());
        result = result * 31 + (this.jwtPrincipalClaims == null ? 0 : this.jwtPrincipalClaims.hashCode());
        result = result * 31 + (this.callbackUrl == null ? 0 : this.callbackUrl.hashCode());
        result = result * 31 + (this.samlConfiguration == null ? 0 : this.samlConfiguration.hashCode());
        result = result * 31 + (this.ldapConfiguration == null ? 0 : this.ldapConfiguration.hashCode());
        result = result * 31 + (this.providerName == null ? 0 : this.providerName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthenticationConfiguration)) {
            return false;
        }
        AuthenticationConfiguration rhs = (AuthenticationConfiguration)other;
        return (this.enableSelfSignup == rhs.enableSelfSignup || this.enableSelfSignup != null && this.enableSelfSignup.equals(rhs.enableSelfSignup)) && (this.clientId == rhs.clientId || this.clientId != null && this.clientId.equals(rhs.clientId)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals(rhs.provider)) && (this.publicKeyUrls == rhs.publicKeyUrls || this.publicKeyUrls != null && this.publicKeyUrls.equals(rhs.publicKeyUrls)) && (this.authority == rhs.authority || this.authority != null && this.authority.equals(rhs.authority)) && (this.jwtPrincipalClaims == rhs.jwtPrincipalClaims || this.jwtPrincipalClaims != null && this.jwtPrincipalClaims.equals(rhs.jwtPrincipalClaims)) && (this.callbackUrl == rhs.callbackUrl || this.callbackUrl != null && this.callbackUrl.equals(rhs.callbackUrl)) && (this.samlConfiguration == rhs.samlConfiguration || this.samlConfiguration != null && this.samlConfiguration.equals(rhs.samlConfiguration)) && (this.ldapConfiguration == rhs.ldapConfiguration || this.ldapConfiguration != null && this.ldapConfiguration.equals(rhs.ldapConfiguration)) && (this.providerName == rhs.providerName || this.providerName != null && this.providerName.equals(rhs.providerName));
    }
}

