/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.security.jwt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"rsapublicKeyFilePath", "rsaprivateKeyFilePath", "jwtissuer", "keyId"})
public class JWTTokenConfiguration {
    @JsonProperty(value="rsapublicKeyFilePath")
    @JsonPropertyDescription(value="RSA Public Key File Path")
    private String rsapublicKeyFilePath;
    @JsonProperty(value="rsaprivateKeyFilePath")
    @JsonPropertyDescription(value="RSA Private Key File Path")
    private String rsaprivateKeyFilePath;
    @JsonProperty(value="jwtissuer")
    @JsonPropertyDescription(value="JWT Issuer")
    @NotNull
    private String jwtissuer;
    @JsonProperty(value="keyId")
    @JsonPropertyDescription(value="Key ID")
    @NotNull
    private String keyId;

    @JsonProperty(value="rsapublicKeyFilePath")
    public String getRsapublicKeyFilePath() {
        return this.rsapublicKeyFilePath;
    }

    @JsonProperty(value="rsapublicKeyFilePath")
    public void setRsapublicKeyFilePath(String rsapublicKeyFilePath) {
        this.rsapublicKeyFilePath = rsapublicKeyFilePath;
    }

    public JWTTokenConfiguration withRsapublicKeyFilePath(String rsapublicKeyFilePath) {
        this.rsapublicKeyFilePath = rsapublicKeyFilePath;
        return this;
    }

    @JsonProperty(value="rsaprivateKeyFilePath")
    public String getRsaprivateKeyFilePath() {
        return this.rsaprivateKeyFilePath;
    }

    @JsonProperty(value="rsaprivateKeyFilePath")
    public void setRsaprivateKeyFilePath(String rsaprivateKeyFilePath) {
        this.rsaprivateKeyFilePath = rsaprivateKeyFilePath;
    }

    public JWTTokenConfiguration withRsaprivateKeyFilePath(String rsaprivateKeyFilePath) {
        this.rsaprivateKeyFilePath = rsaprivateKeyFilePath;
        return this;
    }

    @JsonProperty(value="jwtissuer")
    public String getJwtissuer() {
        return this.jwtissuer;
    }

    @JsonProperty(value="jwtissuer")
    public void setJwtissuer(String jwtissuer) {
        this.jwtissuer = jwtissuer;
    }

    public JWTTokenConfiguration withJwtissuer(String jwtissuer) {
        this.jwtissuer = jwtissuer;
        return this;
    }

    @JsonProperty(value="keyId")
    public String getKeyId() {
        return this.keyId;
    }

    @JsonProperty(value="keyId")
    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public JWTTokenConfiguration withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JWTTokenConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("rsapublicKeyFilePath");
        sb.append('=');
        sb.append(this.rsapublicKeyFilePath == null ? "<null>" : this.rsapublicKeyFilePath);
        sb.append(',');
        sb.append("rsaprivateKeyFilePath");
        sb.append('=');
        sb.append(this.rsaprivateKeyFilePath == null ? "<null>" : this.rsaprivateKeyFilePath);
        sb.append(',');
        sb.append("jwtissuer");
        sb.append('=');
        sb.append(this.jwtissuer == null ? "<null>" : this.jwtissuer);
        sb.append(',');
        sb.append("keyId");
        sb.append('=');
        sb.append(this.keyId == null ? "<null>" : this.keyId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.keyId == null ? 0 : this.keyId.hashCode());
        result = result * 31 + (this.jwtissuer == null ? 0 : this.jwtissuer.hashCode());
        result = result * 31 + (this.rsaprivateKeyFilePath == null ? 0 : this.rsaprivateKeyFilePath.hashCode());
        result = result * 31 + (this.rsapublicKeyFilePath == null ? 0 : this.rsapublicKeyFilePath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JWTTokenConfiguration)) {
            return false;
        }
        JWTTokenConfiguration rhs = (JWTTokenConfiguration)other;
        return (this.keyId == rhs.keyId || this.keyId != null && this.keyId.equals(rhs.keyId)) && (this.jwtissuer == rhs.jwtissuer || this.jwtissuer != null && this.jwtissuer.equals(rhs.jwtissuer)) && (this.rsaprivateKeyFilePath == rhs.rsaprivateKeyFilePath || this.rsaprivateKeyFilePath != null && this.rsaprivateKeyFilePath.equals(rhs.rsaprivateKeyFilePath)) && (this.rsapublicKeyFilePath == rhs.rsapublicKeyFilePath || this.rsapublicKeyFilePath != null && this.rsapublicKeyFilePath.equals(rhs.rsapublicKeyFilePath));
    }
}

