/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.teams;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "description", "policies"})
public class CreateRole
implements CreateEntity {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Optional name used for display purposes. Example 'Data Consumer'")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="policies")
    @JsonPropertyDescription(value="Policies that is attached to this role. At least one policy is required.")
    @Valid
    @NotNull
    private List<String> policies = new ArrayList<String>();

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateRole withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateRole withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateRole withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="policies")
    public List<String> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    public void setPolicies(List<String> policies) {
        this.policies = policies;
    }

    public CreateRole withPolicies(List<String> policies) {
        this.policies = policies;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateRole.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("policies");
        sb.append('=');
        sb.append(this.policies == null ? "<null>" : this.policies);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.policies == null ? 0 : this.policies.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateRole)) {
            return false;
        }
        CreateRole rhs = (CreateRole)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.policies == rhs.policies || this.policies != null && this.policies.equals(rhs.policies)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName));
    }
}

