/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.api.teams;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Profile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"teamType", "name", "displayName", "description", "profile", "parents", "children", "users", "defaultRoles", "owner", "isJoinable", "policies"})
public class CreateTeam
implements CreateEntity {
    @JsonProperty(value="teamType")
    @JsonPropertyDescription(value="Organization is the highest level entity. An Organization has one of more Business Units, Division, Departments, Group, or Users. A Business Unit has one or more Divisions, Departments, Group, or Users. A Division has one or more Divisions, Departments, Group, or Users. A Department has one or more Departments, Group, or Users. A Group has a only Users")
    @NotNull
    private TeamType teamType = TeamType.fromValue("Group");
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Optional name used for display purposes. Example 'Marketing Team'.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="This schema defines the type for a profile of a user, team, or organization.")
    @Valid
    private Profile profile;
    @JsonProperty(value="parents")
    @JsonPropertyDescription(value="Parent teams. For an `Organization` the `parent` is always null. A `BusinessUnit` always has only one parent of type `BusinessUnit` or an `Organization`. A `Division` can have multiple parents of type `BusinessUnit` or `Division`. A `Department` can have multiple parents of type `Division` or `Department`.")
    @Valid
    private List<UUID> parents = null;
    @JsonProperty(value="children")
    @JsonPropertyDescription(value="Children teams. An `Organization` can have `BusinessUnit`, `Division` or `Department` as children. A `BusinessUnit` can have `BusinessUnit`, `Division`, or `Department` as children. A `Division` can have `Division` or `Department` as children. A `Department` can have can have `Department` as children.")
    @Valid
    private List<UUID> children = null;
    @JsonProperty(value="users")
    @JsonPropertyDescription(value="Optional IDs of users that are part of the team.")
    @Valid
    private List<UUID> users = null;
    @JsonProperty(value="defaultRoles")
    @JsonPropertyDescription(value="Roles to be assigned to all users that are part of this team.")
    @Valid
    private List<UUID> defaultRoles = null;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="isJoinable")
    @JsonPropertyDescription(value="Can any user join this team during sign up? Value of true indicates yes, and false no.")
    private Boolean isJoinable = true;
    @JsonProperty(value="policies")
    @JsonPropertyDescription(value="Policies that is attached to this team.")
    @Valid
    private List<UUID> policies = null;

    @JsonProperty(value="teamType")
    public TeamType getTeamType() {
        return this.teamType;
    }

    @JsonProperty(value="teamType")
    public void setTeamType(TeamType teamType) {
        this.teamType = teamType;
    }

    public CreateTeam withTeamType(TeamType teamType) {
        this.teamType = teamType;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public CreateTeam withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTeam withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTeam withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="profile")
    public Profile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public CreateTeam withProfile(Profile profile) {
        this.profile = profile;
        return this;
    }

    @JsonProperty(value="parents")
    public List<UUID> getParents() {
        return this.parents;
    }

    @JsonProperty(value="parents")
    public void setParents(List<UUID> parents) {
        this.parents = parents;
    }

    public CreateTeam withParents(List<UUID> parents) {
        this.parents = parents;
        return this;
    }

    @JsonProperty(value="children")
    public List<UUID> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    public void setChildren(List<UUID> children) {
        this.children = children;
    }

    public CreateTeam withChildren(List<UUID> children) {
        this.children = children;
        return this;
    }

    @JsonProperty(value="users")
    public List<UUID> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<UUID> users) {
        this.users = users;
    }

    public CreateTeam withUsers(List<UUID> users) {
        this.users = users;
        return this;
    }

    @JsonProperty(value="defaultRoles")
    public List<UUID> getDefaultRoles() {
        return this.defaultRoles;
    }

    @JsonProperty(value="defaultRoles")
    public void setDefaultRoles(List<UUID> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public CreateTeam withDefaultRoles(List<UUID> defaultRoles) {
        this.defaultRoles = defaultRoles;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public CreateTeam withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="isJoinable")
    public Boolean getIsJoinable() {
        return this.isJoinable;
    }

    @JsonProperty(value="isJoinable")
    public void setIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
    }

    public CreateTeam withIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
        return this;
    }

    @JsonProperty(value="policies")
    public List<UUID> getPolicies() {
        return this.policies;
    }

    @JsonProperty(value="policies")
    public void setPolicies(List<UUID> policies) {
        this.policies = policies;
    }

    public CreateTeam withPolicies(List<UUID> policies) {
        this.policies = policies;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreateTeam.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("teamType");
        sb.append('=');
        sb.append(this.teamType == null ? "<null>" : this.teamType);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("profile");
        sb.append('=');
        sb.append(this.profile == null ? "<null>" : this.profile);
        sb.append(',');
        sb.append("parents");
        sb.append('=');
        sb.append(this.parents == null ? "<null>" : this.parents);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(this.users == null ? "<null>" : this.users);
        sb.append(',');
        sb.append("defaultRoles");
        sb.append('=');
        sb.append(this.defaultRoles == null ? "<null>" : this.defaultRoles);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("isJoinable");
        sb.append('=');
        sb.append(this.isJoinable == null ? "<null>" : this.isJoinable);
        sb.append(',');
        sb.append("policies");
        sb.append('=');
        sb.append(this.policies == null ? "<null>" : this.policies);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.profile == null ? 0 : this.profile.hashCode());
        result = result * 31 + (this.policies == null ? 0 : this.policies.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.users == null ? 0 : this.users.hashCode());
        result = result * 31 + (this.children == null ? 0 : this.children.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.defaultRoles == null ? 0 : this.defaultRoles.hashCode());
        result = result * 31 + (this.teamType == null ? 0 : this.teamType.hashCode());
        result = result * 31 + (this.isJoinable == null ? 0 : this.isJoinable.hashCode());
        result = result * 31 + (this.parents == null ? 0 : this.parents.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreateTeam)) {
            return false;
        }
        CreateTeam rhs = (CreateTeam)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.profile == rhs.profile || this.profile != null && this.profile.equals(rhs.profile)) && (this.policies == rhs.policies || this.policies != null && this.policies.equals(rhs.policies)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.users == rhs.users || this.users != null && this.users.equals(rhs.users)) && (this.children == rhs.children || this.children != null && this.children.equals(rhs.children)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.defaultRoles == rhs.defaultRoles || this.defaultRoles != null && this.defaultRoles.equals(rhs.defaultRoles)) && (this.teamType == rhs.teamType || this.teamType != null && this.teamType.equals((Object)rhs.teamType)) && (this.isJoinable == rhs.isJoinable || this.isJoinable != null && this.isJoinable.equals(rhs.isJoinable)) && (this.parents == rhs.parents || this.parents != null && this.parents.equals(rhs.parents));
    }

    public static enum TeamType {
        GROUP("Group"),
        DEPARTMENT("Department"),
        DIVISION("Division"),
        BUSINESS_UNIT("BusinessUnit"),
        ORGANIZATION("Organization");

        private final String value;
        private static final Map<String, TeamType> CONSTANTS;

        private TeamType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TeamType fromValue(String value) {
            TeamType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TeamType>();
            for (TeamType c : TeamType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

