/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.auth.JWTTokenExpiry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tokenName", "JWTTokenExpiry"})
public class CreatePersonalToken {
    @JsonProperty(value="tokenName")
    @JsonPropertyDescription(value="Name of the Personal Access Token")
    @NotNull
    private String tokenName;
    @JsonProperty(value="JWTTokenExpiry")
    @JsonPropertyDescription(value="JWT Auth Token expiration in days")
    @NotNull
    private JWTTokenExpiry jWTTokenExpiry;

    @JsonProperty(value="tokenName")
    public String getTokenName() {
        return this.tokenName;
    }

    @JsonProperty(value="tokenName")
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public CreatePersonalToken withTokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    @JsonProperty(value="JWTTokenExpiry")
    public JWTTokenExpiry getJWTTokenExpiry() {
        return this.jWTTokenExpiry;
    }

    @JsonProperty(value="JWTTokenExpiry")
    public void setJWTTokenExpiry(JWTTokenExpiry jWTTokenExpiry) {
        this.jWTTokenExpiry = jWTTokenExpiry;
    }

    public CreatePersonalToken withJWTTokenExpiry(JWTTokenExpiry jWTTokenExpiry) {
        this.jWTTokenExpiry = jWTTokenExpiry;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CreatePersonalToken.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tokenName");
        sb.append('=');
        sb.append(this.tokenName == null ? "<null>" : this.tokenName);
        sb.append(',');
        sb.append("jWTTokenExpiry");
        sb.append('=');
        sb.append(this.jWTTokenExpiry == null ? "<null>" : this.jWTTokenExpiry);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.tokenName == null ? 0 : this.tokenName.hashCode());
        result = result * 31 + (this.jWTTokenExpiry == null ? 0 : this.jWTTokenExpiry.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CreatePersonalToken)) {
            return false;
        }
        CreatePersonalToken rhs = (CreatePersonalToken)other;
        return (this.tokenName == rhs.tokenName || this.tokenName != null && this.tokenName.equals(rhs.tokenName)) && (this.jWTTokenExpiry == rhs.jWTTokenExpiry || this.jWTTokenExpiry != null && this.jWTTokenExpiry.equals((Object)rhs.jWTTokenExpiry));
    }
}

