/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"email"})
public class EmailRequest {
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^\\S+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    @NotNull
    private @Pattern(regexp="^\\S+@\\S+\\.\\S+$") @Size(min=6, max=127) @NotNull String email;

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public EmailRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EmailRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EmailRequest)) {
            return false;
        }
        EmailRequest rhs = (EmailRequest)other;
        return this.email == rhs.email || this.email != null && this.email.equals(rhs.email);
    }
}

