/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.auth;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.auth.ldapTrustStoreConfig.TruststoreConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"host", "port", "maxPoolSize", "isFullDn", "dnAdminPrincipal", "dnAdminPassword", "sslEnabled", "userBaseDN", "mailAttributeName", "truststoreFormat", "truststoreConfigType", "trustStoreConfig"})
public class LdapConfiguration {
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="LDAP server address without scheme(Example :- localhost)")
    @NotNull
    private String host;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="Port of the server")
    @NotNull
    private Integer port;
    @JsonProperty(value="maxPoolSize")
    @JsonPropertyDescription(value="No of connection to create the pool with")
    private Integer maxPoolSize = 3;
    @JsonProperty(value="isFullDn")
    @JsonPropertyDescription(value="If enable need to give full dn to login")
    private Boolean isFullDn = false;
    @JsonProperty(value="dnAdminPrincipal")
    @JsonPropertyDescription(value="Distinguished Admin name with search capabilities")
    @NotNull
    private String dnAdminPrincipal;
    @JsonProperty(value="dnAdminPassword")
    @JsonPropertyDescription(value="Password for LDAP Admin")
    @NotNull
    private String dnAdminPassword;
    @JsonProperty(value="sslEnabled")
    @JsonPropertyDescription(value="LDAPS (secure LDAP) or LDAP")
    private Boolean sslEnabled = false;
    @JsonProperty(value="userBaseDN")
    @JsonPropertyDescription(value="User base distinguished name")
    @NotNull
    private String userBaseDN;
    @JsonProperty(value="mailAttributeName")
    @JsonPropertyDescription(value="Email attribute name")
    @NotNull
    private String mailAttributeName;
    @JsonProperty(value="truststoreFormat")
    @JsonPropertyDescription(value="Truststore format e.g. PKCS12, JKS.")
    private String truststoreFormat;
    @JsonProperty(value="truststoreConfigType")
    @JsonPropertyDescription(value="Truststore Type e.g. TrustAll, HostName, JVMDefault, CustomTrustStore.")
    private TruststoreConfigType truststoreConfigType;
    @JsonProperty(value="trustStoreConfig")
    @JsonPropertyDescription(value="Truststore Configuration")
    @Valid
    private TruststoreConfig trustStoreConfig;

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public LdapConfiguration withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    public LdapConfiguration withPort(Integer port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="maxPoolSize")
    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @JsonProperty(value="maxPoolSize")
    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public LdapConfiguration withMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    @JsonProperty(value="isFullDn")
    public Boolean getIsFullDn() {
        return this.isFullDn;
    }

    @JsonProperty(value="isFullDn")
    public void setIsFullDn(Boolean isFullDn) {
        this.isFullDn = isFullDn;
    }

    public LdapConfiguration withIsFullDn(Boolean isFullDn) {
        this.isFullDn = isFullDn;
        return this;
    }

    @JsonProperty(value="dnAdminPrincipal")
    public String getDnAdminPrincipal() {
        return this.dnAdminPrincipal;
    }

    @JsonProperty(value="dnAdminPrincipal")
    public void setDnAdminPrincipal(String dnAdminPrincipal) {
        this.dnAdminPrincipal = dnAdminPrincipal;
    }

    public LdapConfiguration withDnAdminPrincipal(String dnAdminPrincipal) {
        this.dnAdminPrincipal = dnAdminPrincipal;
        return this;
    }

    @JsonProperty(value="dnAdminPassword")
    public String getDnAdminPassword() {
        return this.dnAdminPassword;
    }

    @JsonProperty(value="dnAdminPassword")
    public void setDnAdminPassword(String dnAdminPassword) {
        this.dnAdminPassword = dnAdminPassword;
    }

    public LdapConfiguration withDnAdminPassword(String dnAdminPassword) {
        this.dnAdminPassword = dnAdminPassword;
        return this;
    }

    @JsonProperty(value="sslEnabled")
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @JsonProperty(value="sslEnabled")
    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public LdapConfiguration withSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @JsonProperty(value="userBaseDN")
    public String getUserBaseDN() {
        return this.userBaseDN;
    }

    @JsonProperty(value="userBaseDN")
    public void setUserBaseDN(String userBaseDN) {
        this.userBaseDN = userBaseDN;
    }

    public LdapConfiguration withUserBaseDN(String userBaseDN) {
        this.userBaseDN = userBaseDN;
        return this;
    }

    @JsonProperty(value="mailAttributeName")
    public String getMailAttributeName() {
        return this.mailAttributeName;
    }

    @JsonProperty(value="mailAttributeName")
    public void setMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
    }

    public LdapConfiguration withMailAttributeName(String mailAttributeName) {
        this.mailAttributeName = mailAttributeName;
        return this;
    }

    @JsonProperty(value="truststoreFormat")
    public String getTruststoreFormat() {
        return this.truststoreFormat;
    }

    @JsonProperty(value="truststoreFormat")
    public void setTruststoreFormat(String truststoreFormat) {
        this.truststoreFormat = truststoreFormat;
    }

    public LdapConfiguration withTruststoreFormat(String truststoreFormat) {
        this.truststoreFormat = truststoreFormat;
        return this;
    }

    @JsonProperty(value="truststoreConfigType")
    public TruststoreConfigType getTruststoreConfigType() {
        return this.truststoreConfigType;
    }

    @JsonProperty(value="truststoreConfigType")
    public void setTruststoreConfigType(TruststoreConfigType truststoreConfigType) {
        this.truststoreConfigType = truststoreConfigType;
    }

    public LdapConfiguration withTruststoreConfigType(TruststoreConfigType truststoreConfigType) {
        this.truststoreConfigType = truststoreConfigType;
        return this;
    }

    @JsonProperty(value="trustStoreConfig")
    public TruststoreConfig getTrustStoreConfig() {
        return this.trustStoreConfig;
    }

    @JsonProperty(value="trustStoreConfig")
    public void setTrustStoreConfig(TruststoreConfig trustStoreConfig) {
        this.trustStoreConfig = trustStoreConfig;
    }

    public LdapConfiguration withTrustStoreConfig(TruststoreConfig trustStoreConfig) {
        this.trustStoreConfig = trustStoreConfig;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LdapConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(this.port == null ? "<null>" : this.port);
        sb.append(',');
        sb.append("maxPoolSize");
        sb.append('=');
        sb.append(this.maxPoolSize == null ? "<null>" : this.maxPoolSize);
        sb.append(',');
        sb.append("isFullDn");
        sb.append('=');
        sb.append(this.isFullDn == null ? "<null>" : this.isFullDn);
        sb.append(',');
        sb.append("dnAdminPrincipal");
        sb.append('=');
        sb.append(this.dnAdminPrincipal == null ? "<null>" : this.dnAdminPrincipal);
        sb.append(',');
        sb.append("dnAdminPassword");
        sb.append('=');
        sb.append(this.dnAdminPassword == null ? "<null>" : this.dnAdminPassword);
        sb.append(',');
        sb.append("sslEnabled");
        sb.append('=');
        sb.append(this.sslEnabled == null ? "<null>" : this.sslEnabled);
        sb.append(',');
        sb.append("userBaseDN");
        sb.append('=');
        sb.append(this.userBaseDN == null ? "<null>" : this.userBaseDN);
        sb.append(',');
        sb.append("mailAttributeName");
        sb.append('=');
        sb.append(this.mailAttributeName == null ? "<null>" : this.mailAttributeName);
        sb.append(',');
        sb.append("truststoreFormat");
        sb.append('=');
        sb.append(this.truststoreFormat == null ? "<null>" : this.truststoreFormat);
        sb.append(',');
        sb.append("truststoreConfigType");
        sb.append('=');
        sb.append(this.truststoreConfigType == null ? "<null>" : this.truststoreConfigType);
        sb.append(',');
        sb.append("trustStoreConfig");
        sb.append('=');
        sb.append(this.trustStoreConfig == null ? "<null>" : this.trustStoreConfig);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.truststoreConfigType == null ? 0 : this.truststoreConfigType.hashCode());
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.mailAttributeName == null ? 0 : this.mailAttributeName.hashCode());
        result = result * 31 + (this.truststoreFormat == null ? 0 : this.truststoreFormat.hashCode());
        result = result * 31 + (this.trustStoreConfig == null ? 0 : this.trustStoreConfig.hashCode());
        result = result * 31 + (this.dnAdminPassword == null ? 0 : this.dnAdminPassword.hashCode());
        result = result * 31 + (this.sslEnabled == null ? 0 : this.sslEnabled.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.dnAdminPrincipal == null ? 0 : this.dnAdminPrincipal.hashCode());
        result = result * 31 + (this.maxPoolSize == null ? 0 : this.maxPoolSize.hashCode());
        result = result * 31 + (this.isFullDn == null ? 0 : this.isFullDn.hashCode());
        result = result * 31 + (this.userBaseDN == null ? 0 : this.userBaseDN.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LdapConfiguration)) {
            return false;
        }
        LdapConfiguration rhs = (LdapConfiguration)other;
        return (this.truststoreConfigType == rhs.truststoreConfigType || this.truststoreConfigType != null && this.truststoreConfigType.equals((Object)rhs.truststoreConfigType)) && (this.port == rhs.port || this.port != null && this.port.equals(rhs.port)) && (this.mailAttributeName == rhs.mailAttributeName || this.mailAttributeName != null && this.mailAttributeName.equals(rhs.mailAttributeName)) && (this.truststoreFormat == rhs.truststoreFormat || this.truststoreFormat != null && this.truststoreFormat.equals(rhs.truststoreFormat)) && (this.trustStoreConfig == rhs.trustStoreConfig || this.trustStoreConfig != null && this.trustStoreConfig.equals(rhs.trustStoreConfig)) && (this.dnAdminPassword == rhs.dnAdminPassword || this.dnAdminPassword != null && this.dnAdminPassword.equals(rhs.dnAdminPassword)) && (this.sslEnabled == rhs.sslEnabled || this.sslEnabled != null && this.sslEnabled.equals(rhs.sslEnabled)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.dnAdminPrincipal == rhs.dnAdminPrincipal || this.dnAdminPrincipal != null && this.dnAdminPrincipal.equals(rhs.dnAdminPrincipal)) && (this.maxPoolSize == rhs.maxPoolSize || this.maxPoolSize != null && this.maxPoolSize.equals(rhs.maxPoolSize)) && (this.isFullDn == rhs.isFullDn || this.isFullDn != null && this.isFullDn.equals(rhs.isFullDn)) && (this.userBaseDN == rhs.userBaseDN || this.userBaseDN != null && this.userBaseDN.equals(rhs.userBaseDN));
    }

    public static enum TruststoreConfigType {
        TRUST_ALL("TrustAll"),
        JVM_DEFAULT("JVMDefault"),
        HOST_NAME("HostName"),
        CUSTOM_TRUST_STORE("CustomTrustStore");

        private final String value;
        private static final Map<String, TruststoreConfigType> CONSTANTS;

        private TruststoreConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TruststoreConfigType fromValue(String value) {
            TruststoreConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TruststoreConfigType>();
            for (TruststoreConfigType c : TruststoreConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

