/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.dataInsight.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum KpiTargetType {
    NUMBER("NUMBER"),
    PERCENTAGE("PERCENTAGE");

    private final String value;
    private static final Map<String, KpiTargetType> CONSTANTS;

    private KpiTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static KpiTargetType fromValue(String value) {
        KpiTargetType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, KpiTargetType>();
        for (KpiTargetType c : KpiTargetType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

