/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.email;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.email.NameEmailPair;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"senderName", "senderMail", "recipientMails", "ccMails", "bccMails", "subject", "contentType", "content"})
public class EmailRequest {
    @JsonProperty(value="senderName")
    @JsonPropertyDescription(value="Sender Name")
    private String senderName;
    @JsonProperty(value="senderMail")
    @JsonPropertyDescription(value="From Email Address")
    private String senderMail;
    @JsonProperty(value="recipientMails")
    @JsonPropertyDescription(value="List of Receiver Name with Email")
    @Valid
    private List<NameEmailPair> recipientMails = new ArrayList<NameEmailPair>();
    @JsonProperty(value="ccMails")
    @JsonPropertyDescription(value="List of CC")
    @Valid
    private List<NameEmailPair> ccMails = new ArrayList<NameEmailPair>();
    @JsonProperty(value="bccMails")
    @JsonPropertyDescription(value="List of BCC")
    @Valid
    private List<NameEmailPair> bccMails = new ArrayList<NameEmailPair>();
    @JsonProperty(value="subject")
    @JsonPropertyDescription(value="Subject for Mail")
    @NotNull
    private String subject;
    @JsonProperty(value="contentType")
    @NotNull
    private ContentType contentType = ContentType.fromValue("plain");
    @JsonProperty(value="content")
    @JsonPropertyDescription(value="Content for mail")
    private String content;

    @JsonProperty(value="senderName")
    public String getSenderName() {
        return this.senderName;
    }

    @JsonProperty(value="senderName")
    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public EmailRequest withSenderName(String senderName) {
        this.senderName = senderName;
        return this;
    }

    @JsonProperty(value="senderMail")
    public String getSenderMail() {
        return this.senderMail;
    }

    @JsonProperty(value="senderMail")
    public void setSenderMail(String senderMail) {
        this.senderMail = senderMail;
    }

    public EmailRequest withSenderMail(String senderMail) {
        this.senderMail = senderMail;
        return this;
    }

    @JsonProperty(value="recipientMails")
    public List<NameEmailPair> getRecipientMails() {
        return this.recipientMails;
    }

    @JsonProperty(value="recipientMails")
    public void setRecipientMails(List<NameEmailPair> recipientMails) {
        this.recipientMails = recipientMails;
    }

    public EmailRequest withRecipientMails(List<NameEmailPair> recipientMails) {
        this.recipientMails = recipientMails;
        return this;
    }

    @JsonProperty(value="ccMails")
    public List<NameEmailPair> getCcMails() {
        return this.ccMails;
    }

    @JsonProperty(value="ccMails")
    public void setCcMails(List<NameEmailPair> ccMails) {
        this.ccMails = ccMails;
    }

    public EmailRequest withCcMails(List<NameEmailPair> ccMails) {
        this.ccMails = ccMails;
        return this;
    }

    @JsonProperty(value="bccMails")
    public List<NameEmailPair> getBccMails() {
        return this.bccMails;
    }

    @JsonProperty(value="bccMails")
    public void setBccMails(List<NameEmailPair> bccMails) {
        this.bccMails = bccMails;
    }

    public EmailRequest withBccMails(List<NameEmailPair> bccMails) {
        this.bccMails = bccMails;
        return this;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailRequest withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty(value="contentType")
    public ContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public EmailRequest withContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(String content) {
        this.content = content;
    }

    public EmailRequest withContent(String content) {
        this.content = content;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EmailRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("senderName");
        sb.append('=');
        sb.append(this.senderName == null ? "<null>" : this.senderName);
        sb.append(',');
        sb.append("senderMail");
        sb.append('=');
        sb.append(this.senderMail == null ? "<null>" : this.senderMail);
        sb.append(',');
        sb.append("recipientMails");
        sb.append('=');
        sb.append(this.recipientMails == null ? "<null>" : this.recipientMails);
        sb.append(',');
        sb.append("ccMails");
        sb.append('=');
        sb.append(this.ccMails == null ? "<null>" : this.ccMails);
        sb.append(',');
        sb.append("bccMails");
        sb.append('=');
        sb.append(this.bccMails == null ? "<null>" : this.bccMails);
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(this.subject == null ? "<null>" : this.subject);
        sb.append(',');
        sb.append("contentType");
        sb.append('=');
        sb.append(this.contentType == null ? "<null>" : this.contentType);
        sb.append(',');
        sb.append("content");
        sb.append('=');
        sb.append(this.content == null ? "<null>" : this.content);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.senderName == null ? 0 : this.senderName.hashCode());
        result = result * 31 + (this.subject == null ? 0 : this.subject.hashCode());
        result = result * 31 + (this.recipientMails == null ? 0 : this.recipientMails.hashCode());
        result = result * 31 + (this.bccMails == null ? 0 : this.bccMails.hashCode());
        result = result * 31 + (this.contentType == null ? 0 : this.contentType.hashCode());
        result = result * 31 + (this.senderMail == null ? 0 : this.senderMail.hashCode());
        result = result * 31 + (this.content == null ? 0 : this.content.hashCode());
        result = result * 31 + (this.ccMails == null ? 0 : this.ccMails.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EmailRequest)) {
            return false;
        }
        EmailRequest rhs = (EmailRequest)other;
        return (this.senderName == rhs.senderName || this.senderName != null && this.senderName.equals(rhs.senderName)) && (this.subject == rhs.subject || this.subject != null && this.subject.equals(rhs.subject)) && (this.recipientMails == rhs.recipientMails || this.recipientMails != null && this.recipientMails.equals(rhs.recipientMails)) && (this.bccMails == rhs.bccMails || this.bccMails != null && this.bccMails.equals(rhs.bccMails)) && (this.contentType == rhs.contentType || this.contentType != null && this.contentType.equals((Object)rhs.contentType)) && (this.senderMail == rhs.senderMail || this.senderMail != null && this.senderMail.equals(rhs.senderMail)) && (this.content == rhs.content || this.content != null && this.content.equals(rhs.content)) && (this.ccMails == rhs.ccMails || this.ccMails != null && this.ccMails.equals(rhs.ccMails));
    }

    public static enum ContentType {
        PLAIN("plain"),
        HTML("html");

        private final String value;
        private static final Map<String, ContentType> CONSTANTS;

        private ContentType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ContentType fromValue(String value) {
            ContentType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ContentType>();
            for (ContentType c : ContentType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

