/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.Votes;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "version", "updatedAt", "updatedBy", "href", "changeDescription", "owner", "duration", "users", "followers", "votes", "query", "checksum", "queryDate", "tags", "queryUsedIn", "deleted"})
public class Query
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Query. It could be title or label.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the query.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="How long did the query took to run in seconds.")
    private Double duration;
    @JsonProperty(value="users")
    @JsonPropertyDescription(value="List of users who ran this query.")
    @Valid
    private List<EntityReference> users = null;
    @JsonProperty(value="followers")
    @Valid
    private List<EntityReference> followers = null;
    @JsonProperty(value="votes")
    @JsonPropertyDescription(value="This schema defines the Votes for a Data Asset.")
    @Valid
    private Votes votes;
    @JsonProperty(value="query")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    @NotNull
    private String query;
    @JsonProperty(value="checksum")
    @JsonPropertyDescription(value="Checksum to avoid registering duplicate queries.")
    private String checksum;
    @JsonProperty(value="queryDate")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long queryDate;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this SQL query.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="queryUsedIn")
    @Valid
    private List<EntityReference> queryUsedIn = null;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Query withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Query withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Query withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Query withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Query withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Query withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Query withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Query withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Query withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Query withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public Query withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty(value="duration")
    public Double getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public Query withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="users")
    public List<EntityReference> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<EntityReference> users) {
        this.users = users;
    }

    public Query withUsers(List<EntityReference> users) {
        this.users = users;
        return this;
    }

    @Override
    @JsonProperty(value="followers")
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public Query withFollowers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    @Override
    @JsonProperty(value="votes")
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    public void setVotes(Votes votes) {
        this.votes = votes;
    }

    public Query withVotes(Votes votes) {
        this.votes = votes;
        return this;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    public Query withQuery(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="checksum")
    public String getChecksum() {
        return this.checksum;
    }

    @JsonProperty(value="checksum")
    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Query withChecksum(String checksum) {
        this.checksum = checksum;
        return this;
    }

    @JsonProperty(value="queryDate")
    public Long getQueryDate() {
        return this.queryDate;
    }

    @JsonProperty(value="queryDate")
    public void setQueryDate(Long queryDate) {
        this.queryDate = queryDate;
    }

    public Query withQueryDate(Long queryDate) {
        this.queryDate = queryDate;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public Query withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="queryUsedIn")
    public List<EntityReference> getQueryUsedIn() {
        return this.queryUsedIn;
    }

    @JsonProperty(value="queryUsedIn")
    public void setQueryUsedIn(List<EntityReference> queryUsedIn) {
        this.queryUsedIn = queryUsedIn;
    }

    public Query withQueryUsedIn(List<EntityReference> queryUsedIn) {
        this.queryUsedIn = queryUsedIn;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Query withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Query.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(this.users == null ? "<null>" : this.users);
        sb.append(',');
        sb.append("followers");
        sb.append('=');
        sb.append(this.followers == null ? "<null>" : this.followers);
        sb.append(',');
        sb.append("votes");
        sb.append('=');
        sb.append(this.votes == null ? "<null>" : this.votes);
        sb.append(',');
        sb.append("query");
        sb.append('=');
        sb.append(this.query == null ? "<null>" : this.query);
        sb.append(',');
        sb.append("checksum");
        sb.append('=');
        sb.append(this.checksum == null ? "<null>" : this.checksum);
        sb.append(',');
        sb.append("queryDate");
        sb.append('=');
        sb.append(this.queryDate == null ? "<null>" : this.queryDate);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("queryUsedIn");
        sb.append('=');
        sb.append(this.queryUsedIn == null ? "<null>" : this.queryUsedIn);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.queryUsedIn == null ? 0 : this.queryUsedIn.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.query == null ? 0 : this.query.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.users == null ? 0 : this.users.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.followers == null ? 0 : this.followers.hashCode());
        result = result * 31 + (this.queryDate == null ? 0 : this.queryDate.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = result * 31 + (this.votes == null ? 0 : this.votes.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Query)) {
            return false;
        }
        Query rhs = (Query)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.queryUsedIn == rhs.queryUsedIn || this.queryUsedIn != null && this.queryUsedIn.equals(rhs.queryUsedIn)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.query == rhs.query || this.query != null && this.query.equals(rhs.query)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.users == rhs.users || this.users != null && this.users.equals(rhs.users)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.followers == rhs.followers || this.followers != null && this.followers.equals(rhs.followers)) && (this.queryDate == rhs.queryDate || this.queryDate != null && this.queryDate.equals(rhs.queryDate)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.checksum == rhs.checksum || this.checksum != null && this.checksum.equals(rhs.checksum)) && (this.votes == rhs.votes || this.votes != null && this.votes.equals(rhs.votes)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

