/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.services.CreateMessagingService;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MessageSchema;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.topic.CleanupPolicy;
import org.openmetadata.schema.type.topic.TopicConfig;
import org.openmetadata.schema.type.topic.TopicSampleData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "version", "updatedAt", "updatedBy", "service", "serviceType", "messageSchema", "partitions", "cleanupPolicies", "retentionTime", "replicationFactor", "maximumMessageSize", "minimumInSyncReplicas", "retentionSize", "topicConfig", "sampleData", "owner", "followers", "tags", "href", "changeDescription", "deleted", "extension"})
public class Topic
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this topic. It could be title or label from the source services.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private EntityReference service;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of messaging service - Kafka or Pulsar.")
    private CreateMessagingService.MessagingServiceType serviceType;
    @JsonProperty(value="messageSchema")
    @JsonPropertyDescription(value="This schema defines the Topic entity. A topic is a feed into which message are published to by publishers and read from by consumers in a messaging service.")
    @Valid
    private MessageSchema messageSchema;
    @JsonProperty(value="partitions")
    @JsonPropertyDescription(value="Number of partitions into which the topic is divided.")
    @DecimalMin(value="1")
    @NotNull
    private @DecimalMin(value="1") @NotNull Integer partitions;
    @JsonProperty(value="cleanupPolicies")
    @JsonPropertyDescription(value="Topic clean up policies. For Kafka - `cleanup.policy` configuration.")
    @Valid
    private List<CleanupPolicy> cleanupPolicies = new ArrayList<CleanupPolicy>();
    @JsonProperty(value="retentionTime")
    @JsonPropertyDescription(value="Retention time in milliseconds. For Kafka - `retention.ms` configuration.")
    private Double retentionTime;
    @JsonProperty(value="replicationFactor")
    @JsonPropertyDescription(value="Replication Factor in integer (more than 1).")
    private Integer replicationFactor;
    @JsonProperty(value="maximumMessageSize")
    @JsonPropertyDescription(value="Maximum message size in bytes. For Kafka - `max.message.bytes` configuration.")
    private Integer maximumMessageSize;
    @JsonProperty(value="minimumInSyncReplicas")
    @JsonPropertyDescription(value="Minimum number replicas in sync to control durability. For Kafka - `min.insync.replicas` configuration.")
    private Integer minimumInSyncReplicas;
    @JsonProperty(value="retentionSize")
    @JsonPropertyDescription(value="Maximum size of a partition in bytes before old data is discarded. For Kafka - `retention.bytes` configuration.")
    private Double retentionSize = -1.0;
    @JsonProperty(value="topicConfig")
    @JsonPropertyDescription(value="Contains key/value pair of topic configuration.")
    @Valid
    private TopicConfig topicConfig;
    @JsonProperty(value="sampleData")
    @JsonPropertyDescription(value="This schema defines the type to capture sample data for a topic.")
    @Valid
    private TopicSampleData sampleData;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="followers")
    @Valid
    private List<EntityReference> followers = null;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this table.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="Entity extension data with custom attributes added to the entity.")
    private Object extension;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Topic withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Topic withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Topic withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Topic withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Topic withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Topic withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Topic withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Topic withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonProperty(value="service")
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(EntityReference service) {
        this.service = service;
    }

    public Topic withService(EntityReference service) {
        this.service = service;
        return this;
    }

    @JsonProperty(value="serviceType")
    public CreateMessagingService.MessagingServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(CreateMessagingService.MessagingServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public Topic withServiceType(CreateMessagingService.MessagingServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @JsonProperty(value="messageSchema")
    public MessageSchema getMessageSchema() {
        return this.messageSchema;
    }

    @JsonProperty(value="messageSchema")
    public void setMessageSchema(MessageSchema messageSchema) {
        this.messageSchema = messageSchema;
    }

    public Topic withMessageSchema(MessageSchema messageSchema) {
        this.messageSchema = messageSchema;
        return this;
    }

    @JsonProperty(value="partitions")
    public Integer getPartitions() {
        return this.partitions;
    }

    @JsonProperty(value="partitions")
    public void setPartitions(Integer partitions) {
        this.partitions = partitions;
    }

    public Topic withPartitions(Integer partitions) {
        this.partitions = partitions;
        return this;
    }

    @JsonProperty(value="cleanupPolicies")
    public List<CleanupPolicy> getCleanupPolicies() {
        return this.cleanupPolicies;
    }

    @JsonProperty(value="cleanupPolicies")
    public void setCleanupPolicies(List<CleanupPolicy> cleanupPolicies) {
        this.cleanupPolicies = cleanupPolicies;
    }

    public Topic withCleanupPolicies(List<CleanupPolicy> cleanupPolicies) {
        this.cleanupPolicies = cleanupPolicies;
        return this;
    }

    @JsonProperty(value="retentionTime")
    public Double getRetentionTime() {
        return this.retentionTime;
    }

    @JsonProperty(value="retentionTime")
    public void setRetentionTime(Double retentionTime) {
        this.retentionTime = retentionTime;
    }

    public Topic withRetentionTime(Double retentionTime) {
        this.retentionTime = retentionTime;
        return this;
    }

    @JsonProperty(value="replicationFactor")
    public Integer getReplicationFactor() {
        return this.replicationFactor;
    }

    @JsonProperty(value="replicationFactor")
    public void setReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public Topic withReplicationFactor(Integer replicationFactor) {
        this.replicationFactor = replicationFactor;
        return this;
    }

    @JsonProperty(value="maximumMessageSize")
    public Integer getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @JsonProperty(value="maximumMessageSize")
    public void setMaximumMessageSize(Integer maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    public Topic withMaximumMessageSize(Integer maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
        return this;
    }

    @JsonProperty(value="minimumInSyncReplicas")
    public Integer getMinimumInSyncReplicas() {
        return this.minimumInSyncReplicas;
    }

    @JsonProperty(value="minimumInSyncReplicas")
    public void setMinimumInSyncReplicas(Integer minimumInSyncReplicas) {
        this.minimumInSyncReplicas = minimumInSyncReplicas;
    }

    public Topic withMinimumInSyncReplicas(Integer minimumInSyncReplicas) {
        this.minimumInSyncReplicas = minimumInSyncReplicas;
        return this;
    }

    @JsonProperty(value="retentionSize")
    public Double getRetentionSize() {
        return this.retentionSize;
    }

    @JsonProperty(value="retentionSize")
    public void setRetentionSize(Double retentionSize) {
        this.retentionSize = retentionSize;
    }

    public Topic withRetentionSize(Double retentionSize) {
        this.retentionSize = retentionSize;
        return this;
    }

    @JsonProperty(value="topicConfig")
    public TopicConfig getTopicConfig() {
        return this.topicConfig;
    }

    @JsonProperty(value="topicConfig")
    public void setTopicConfig(TopicConfig topicConfig) {
        this.topicConfig = topicConfig;
    }

    public Topic withTopicConfig(TopicConfig topicConfig) {
        this.topicConfig = topicConfig;
        return this;
    }

    @JsonProperty(value="sampleData")
    public TopicSampleData getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    public void setSampleData(TopicSampleData sampleData) {
        this.sampleData = sampleData;
    }

    public Topic withSampleData(TopicSampleData sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public Topic withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Override
    @JsonProperty(value="followers")
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public Topic withFollowers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public Topic withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Topic withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Topic withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Topic withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    @JsonProperty(value="extension")
    public Object getExtension() {
        return this.extension;
    }

    @Override
    @JsonProperty(value="extension")
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public Topic withExtension(Object extension) {
        this.extension = extension;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Topic.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("messageSchema");
        sb.append('=');
        sb.append(this.messageSchema == null ? "<null>" : this.messageSchema);
        sb.append(',');
        sb.append("partitions");
        sb.append('=');
        sb.append(this.partitions == null ? "<null>" : this.partitions);
        sb.append(',');
        sb.append("cleanupPolicies");
        sb.append('=');
        sb.append(this.cleanupPolicies == null ? "<null>" : this.cleanupPolicies);
        sb.append(',');
        sb.append("retentionTime");
        sb.append('=');
        sb.append(this.retentionTime == null ? "<null>" : this.retentionTime);
        sb.append(',');
        sb.append("replicationFactor");
        sb.append('=');
        sb.append(this.replicationFactor == null ? "<null>" : this.replicationFactor);
        sb.append(',');
        sb.append("maximumMessageSize");
        sb.append('=');
        sb.append(this.maximumMessageSize == null ? "<null>" : this.maximumMessageSize);
        sb.append(',');
        sb.append("minimumInSyncReplicas");
        sb.append('=');
        sb.append(this.minimumInSyncReplicas == null ? "<null>" : this.minimumInSyncReplicas);
        sb.append(',');
        sb.append("retentionSize");
        sb.append('=');
        sb.append(this.retentionSize == null ? "<null>" : this.retentionSize);
        sb.append(',');
        sb.append("topicConfig");
        sb.append('=');
        sb.append(this.topicConfig == null ? "<null>" : this.topicConfig);
        sb.append(',');
        sb.append("sampleData");
        sb.append('=');
        sb.append(this.sampleData == null ? "<null>" : this.sampleData);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("followers");
        sb.append('=');
        sb.append(this.followers == null ? "<null>" : this.followers);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("extension");
        sb.append('=');
        sb.append(this.extension == null ? "<null>" : this.extension);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.replicationFactor == null ? 0 : this.replicationFactor.hashCode());
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.maximumMessageSize == null ? 0 : this.maximumMessageSize.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.retentionTime == null ? 0 : this.retentionTime.hashCode());
        result = result * 31 + (this.minimumInSyncReplicas == null ? 0 : this.minimumInSyncReplicas.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.partitions == null ? 0 : this.partitions.hashCode());
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.topicConfig == null ? 0 : this.topicConfig.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.cleanupPolicies == null ? 0 : this.cleanupPolicies.hashCode());
        result = result * 31 + (this.followers == null ? 0 : this.followers.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.messageSchema == null ? 0 : this.messageSchema.hashCode());
        result = result * 31 + (this.sampleData == null ? 0 : this.sampleData.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.retentionSize == null ? 0 : this.retentionSize.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Topic)) {
            return false;
        }
        Topic rhs = (Topic)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.replicationFactor == rhs.replicationFactor || this.replicationFactor != null && this.replicationFactor.equals(rhs.replicationFactor)) && (this.extension == rhs.extension || this.extension != null && this.extension.equals(rhs.extension)) && (this.maximumMessageSize == rhs.maximumMessageSize || this.maximumMessageSize != null && this.maximumMessageSize.equals(rhs.maximumMessageSize)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.retentionTime == rhs.retentionTime || this.retentionTime != null && this.retentionTime.equals(rhs.retentionTime)) && (this.minimumInSyncReplicas == rhs.minimumInSyncReplicas || this.minimumInSyncReplicas != null && this.minimumInSyncReplicas.equals(rhs.minimumInSyncReplicas)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.partitions == rhs.partitions || this.partitions != null && this.partitions.equals(rhs.partitions)) && (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.topicConfig == rhs.topicConfig || this.topicConfig != null && this.topicConfig.equals(rhs.topicConfig)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.cleanupPolicies == rhs.cleanupPolicies || this.cleanupPolicies != null && this.cleanupPolicies.equals(rhs.cleanupPolicies)) && (this.followers == rhs.followers || this.followers != null && this.followers.equals(rhs.followers)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.messageSchema == rhs.messageSchema || this.messageSchema != null && this.messageSchema.equals(rhs.messageSchema)) && (this.sampleData == rhs.sampleData || this.sampleData != null && this.sampleData.equals(rhs.sampleData)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.retentionSize == rhs.retentionSize || this.retentionSize != null && this.retentionSize.equals(rhs.retentionSize));
    }
}

