/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.FilteringRules;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "owner", "href", "version", "updatedAt", "updatedBy", "changeDescription", "filteringRules", "subscriptionType", "subscriptionConfig", "enabled", "batchSize", "timeout", "readTimeout", "statusDetails", "deleted", "provider"})
public class EventSubscription
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display name for this Event Subscription.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="filteringRules")
    @JsonPropertyDescription(value="Filtering Rules for Event Subscription.")
    @Valid
    @NotNull
    private FilteringRules filteringRules;
    @JsonProperty(value="subscriptionType")
    @JsonPropertyDescription(value="Subscription Endpoint Type")
    @NotNull
    private CreateEventSubscription.SubscriptionType subscriptionType;
    @JsonProperty(value="subscriptionConfig")
    @NotNull
    private Object subscriptionConfig;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is the event Subscription enabled.")
    private Boolean enabled = true;
    @JsonProperty(value="batchSize")
    @JsonPropertyDescription(value="Maximum number of events sent in a batch (Default 10).")
    private Integer batchSize = 10;
    @JsonProperty(value="timeout")
    @JsonPropertyDescription(value="Connection timeout in seconds. (Default 10s).")
    private Integer timeout = 10;
    @JsonProperty(value="readTimeout")
    @JsonPropertyDescription(value="Read timeout in seconds. (Default 12s).")
    private Integer readTimeout = 12;
    @JsonProperty(value="statusDetails")
    @JsonPropertyDescription(value="Subscription Current Status")
    @Valid
    private SubscriptionStatus statusDetails;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public EventSubscription withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventSubscription withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public EventSubscription withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EventSubscription withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public EventSubscription withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public EventSubscription withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public EventSubscription withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public EventSubscription withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public EventSubscription withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public EventSubscription withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public EventSubscription withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @JsonProperty(value="filteringRules")
    public FilteringRules getFilteringRules() {
        return this.filteringRules;
    }

    @JsonProperty(value="filteringRules")
    public void setFilteringRules(FilteringRules filteringRules) {
        this.filteringRules = filteringRules;
    }

    public EventSubscription withFilteringRules(FilteringRules filteringRules) {
        this.filteringRules = filteringRules;
        return this;
    }

    @JsonProperty(value="subscriptionType")
    public CreateEventSubscription.SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    @JsonProperty(value="subscriptionType")
    public void setSubscriptionType(CreateEventSubscription.SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public EventSubscription withSubscriptionType(CreateEventSubscription.SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
        return this;
    }

    @JsonProperty(value="subscriptionConfig")
    public Object getSubscriptionConfig() {
        return this.subscriptionConfig;
    }

    @JsonProperty(value="subscriptionConfig")
    public void setSubscriptionConfig(Object subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
    }

    public EventSubscription withSubscriptionConfig(Object subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public EventSubscription withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="batchSize")
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @JsonProperty(value="batchSize")
    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public EventSubscription withBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public EventSubscription withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty(value="readTimeout")
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @JsonProperty(value="readTimeout")
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public EventSubscription withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @JsonProperty(value="statusDetails")
    public SubscriptionStatus getStatusDetails() {
        return this.statusDetails;
    }

    @JsonProperty(value="statusDetails")
    public void setStatusDetails(SubscriptionStatus statusDetails) {
        this.statusDetails = statusDetails;
    }

    public EventSubscription withStatusDetails(SubscriptionStatus statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public EventSubscription withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public EventSubscription withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventSubscription.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("filteringRules");
        sb.append('=');
        sb.append(this.filteringRules == null ? "<null>" : this.filteringRules);
        sb.append(',');
        sb.append("subscriptionType");
        sb.append('=');
        sb.append(this.subscriptionType == null ? "<null>" : this.subscriptionType);
        sb.append(',');
        sb.append("subscriptionConfig");
        sb.append('=');
        sb.append(this.subscriptionConfig == null ? "<null>" : this.subscriptionConfig);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("batchSize");
        sb.append('=');
        sb.append(this.batchSize == null ? "<null>" : this.batchSize);
        sb.append(',');
        sb.append("timeout");
        sb.append('=');
        sb.append(this.timeout == null ? "<null>" : this.timeout);
        sb.append(',');
        sb.append("readTimeout");
        sb.append('=');
        sb.append(this.readTimeout == null ? "<null>" : this.readTimeout);
        sb.append(',');
        sb.append("statusDetails");
        sb.append('=');
        sb.append(this.statusDetails == null ? "<null>" : this.statusDetails);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.filteringRules == null ? 0 : this.filteringRules.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.timeout == null ? 0 : this.timeout.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.subscriptionType == null ? 0 : this.subscriptionType.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.subscriptionConfig == null ? 0 : this.subscriptionConfig.hashCode());
        result = result * 31 + (this.readTimeout == null ? 0 : this.readTimeout.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.statusDetails == null ? 0 : this.statusDetails.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.batchSize == null ? 0 : this.batchSize.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventSubscription)) {
            return false;
        }
        EventSubscription rhs = (EventSubscription)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.filteringRules == rhs.filteringRules || this.filteringRules != null && this.filteringRules.equals(rhs.filteringRules)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.timeout == rhs.timeout || this.timeout != null && this.timeout.equals(rhs.timeout)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.subscriptionType == rhs.subscriptionType || this.subscriptionType != null && this.subscriptionType.equals((Object)rhs.subscriptionType)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.subscriptionConfig == rhs.subscriptionConfig || this.subscriptionConfig != null && this.subscriptionConfig.equals(rhs.subscriptionConfig)) && (this.readTimeout == rhs.readTimeout || this.readTimeout != null && this.readTimeout.equals(rhs.readTimeout)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.statusDetails == rhs.statusDetails || this.statusDetails != null && this.statusDetails.equals(rhs.statusDetails)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.batchSize == rhs.batchSize || this.batchSize != null && this.batchSize.equals(rhs.batchSize)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

