/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.feed;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.openmetadata.schema.type.AnnouncementDetails;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.Reaction;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.ThreadType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "type", "href", "threadTs", "about", "entityId", "addressedTo", "createdBy", "updatedAt", "updatedBy", "resolved", "message", "postsCount", "posts", "reactions", "task", "announcement"})
public class Thread {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of thread.")
    private ThreadType type = ThreadType.fromValue("Conversation");
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="threadTs")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long threadTs;
    @JsonProperty(value="about")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$")
    @NotNull
    private @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$") @NotNull String about;
    @JsonProperty(value="entityId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID entityId;
    @JsonProperty(value="addressedTo")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$")
    private @Pattern(regexp="^(?U)<#E::\\w+::[\\w'\\- .&/:+\"\\\\()$#]+>$") String addressedTo;
    @JsonProperty(value="createdBy")
    @JsonPropertyDescription(value="User who created the thread.")
    private String createdBy;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="resolved")
    @JsonPropertyDescription(value="When `true` indicates the thread has been resolved.")
    private Boolean resolved = false;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="The main message of the thread in markdown format.")
    @NotNull
    private String message;
    @JsonProperty(value="postsCount")
    @JsonPropertyDescription(value="The total count of posts in the thread.")
    private Integer postsCount = 0;
    @JsonProperty(value="posts")
    @Valid
    private List<Post> posts = new ArrayList<Post>();
    @JsonProperty(value="reactions")
    @Valid
    private List<Reaction> reactions = null;
    @JsonProperty(value="task")
    @JsonPropertyDescription(value="Details about the task. This is only applicable if thread is of type task.")
    @Valid
    private TaskDetails task;
    @JsonProperty(value="announcement")
    @JsonPropertyDescription(value="Details about the announcement. This is only applicable if thread is of type announcement.")
    @Valid
    private AnnouncementDetails announcement;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Thread withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="type")
    public ThreadType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ThreadType type) {
        this.type = type;
    }

    public Thread withType(ThreadType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Thread withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="threadTs")
    public Long getThreadTs() {
        return this.threadTs;
    }

    @JsonProperty(value="threadTs")
    public void setThreadTs(Long threadTs) {
        this.threadTs = threadTs;
    }

    public Thread withThreadTs(Long threadTs) {
        this.threadTs = threadTs;
        return this;
    }

    @JsonProperty(value="about")
    public String getAbout() {
        return this.about;
    }

    @JsonProperty(value="about")
    public void setAbout(String about) {
        this.about = about;
    }

    public Thread withAbout(String about) {
        this.about = about;
        return this;
    }

    @JsonProperty(value="entityId")
    public UUID getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public Thread withEntityId(UUID entityId) {
        this.entityId = entityId;
        return this;
    }

    @JsonProperty(value="addressedTo")
    public String getAddressedTo() {
        return this.addressedTo;
    }

    @JsonProperty(value="addressedTo")
    public void setAddressedTo(String addressedTo) {
        this.addressedTo = addressedTo;
    }

    public Thread withAddressedTo(String addressedTo) {
        this.addressedTo = addressedTo;
        return this;
    }

    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Thread withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Thread withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Thread withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @JsonProperty(value="resolved")
    public Boolean getResolved() {
        return this.resolved;
    }

    @JsonProperty(value="resolved")
    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public Thread withResolved(Boolean resolved) {
        this.resolved = resolved;
        return this;
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Thread withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="postsCount")
    public Integer getPostsCount() {
        return this.postsCount;
    }

    @JsonProperty(value="postsCount")
    public void setPostsCount(Integer postsCount) {
        this.postsCount = postsCount;
    }

    public Thread withPostsCount(Integer postsCount) {
        this.postsCount = postsCount;
        return this;
    }

    @JsonProperty(value="posts")
    public List<Post> getPosts() {
        return this.posts;
    }

    @JsonProperty(value="posts")
    public void setPosts(List<Post> posts) {
        this.posts = posts;
    }

    public Thread withPosts(List<Post> posts) {
        this.posts = posts;
        return this;
    }

    @JsonProperty(value="reactions")
    public List<Reaction> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="reactions")
    public void setReactions(List<Reaction> reactions) {
        this.reactions = reactions;
    }

    public Thread withReactions(List<Reaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @JsonProperty(value="task")
    public TaskDetails getTask() {
        return this.task;
    }

    @JsonProperty(value="task")
    public void setTask(TaskDetails task) {
        this.task = task;
    }

    public Thread withTask(TaskDetails task) {
        this.task = task;
        return this;
    }

    @JsonProperty(value="announcement")
    public AnnouncementDetails getAnnouncement() {
        return this.announcement;
    }

    @JsonProperty(value="announcement")
    public void setAnnouncement(AnnouncementDetails announcement) {
        this.announcement = announcement;
    }

    public Thread withAnnouncement(AnnouncementDetails announcement) {
        this.announcement = announcement;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("threadTs");
        sb.append('=');
        sb.append(this.threadTs == null ? "<null>" : this.threadTs);
        sb.append(',');
        sb.append("about");
        sb.append('=');
        sb.append(this.about == null ? "<null>" : this.about);
        sb.append(',');
        sb.append("entityId");
        sb.append('=');
        sb.append(this.entityId == null ? "<null>" : this.entityId);
        sb.append(',');
        sb.append("addressedTo");
        sb.append('=');
        sb.append(this.addressedTo == null ? "<null>" : this.addressedTo);
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(this.createdBy == null ? "<null>" : this.createdBy);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("resolved");
        sb.append('=');
        sb.append(this.resolved == null ? "<null>" : this.resolved);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("postsCount");
        sb.append('=');
        sb.append(this.postsCount == null ? "<null>" : this.postsCount);
        sb.append(',');
        sb.append("posts");
        sb.append('=');
        sb.append(this.posts == null ? "<null>" : this.posts);
        sb.append(',');
        sb.append("reactions");
        sb.append('=');
        sb.append(this.reactions == null ? "<null>" : this.reactions);
        sb.append(',');
        sb.append("task");
        sb.append('=');
        sb.append(this.task == null ? "<null>" : this.task);
        sb.append(',');
        sb.append("announcement");
        sb.append('=');
        sb.append(this.announcement == null ? "<null>" : this.announcement);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.addressedTo == null ? 0 : this.addressedTo.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.about == null ? 0 : this.about.hashCode());
        result = result * 31 + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.posts == null ? 0 : this.posts.hashCode());
        result = result * 31 + (this.task == null ? 0 : this.task.hashCode());
        result = result * 31 + (this.createdBy == null ? 0 : this.createdBy.hashCode());
        result = result * 31 + (this.postsCount == null ? 0 : this.postsCount.hashCode());
        result = result * 31 + (this.reactions == null ? 0 : this.reactions.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.threadTs == null ? 0 : this.threadTs.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        result = result * 31 + (this.resolved == null ? 0 : this.resolved.hashCode());
        result = result * 31 + (this.announcement == null ? 0 : this.announcement.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Thread)) {
            return false;
        }
        Thread rhs = (Thread)other;
        return (this.addressedTo == rhs.addressedTo || this.addressedTo != null && this.addressedTo.equals(rhs.addressedTo)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.about == rhs.about || this.about != null && this.about.equals(rhs.about)) && (this.entityId == rhs.entityId || this.entityId != null && this.entityId.equals(rhs.entityId)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.posts == rhs.posts || this.posts != null && this.posts.equals(rhs.posts)) && (this.task == rhs.task || this.task != null && this.task.equals(rhs.task)) && (this.createdBy == rhs.createdBy || this.createdBy != null && this.createdBy.equals(rhs.createdBy)) && (this.postsCount == rhs.postsCount || this.postsCount != null && this.postsCount.equals(rhs.postsCount)) && (this.reactions == rhs.reactions || this.reactions != null && this.reactions.equals(rhs.reactions)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.threadTs == rhs.threadTs || this.threadTs != null && this.threadTs.equals(rhs.threadTs)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt)) && (this.resolved == rhs.resolved || this.resolved != null && this.resolved.equals(rhs.resolved)) && (this.announcement == rhs.announcement || this.announcement != null && this.announcement.equals(rhs.announcement));
    }
}

