/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.policies;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "fullyQualifiedName", "displayName", "description", "owner", "href", "enabled", "version", "updatedAt", "updatedBy", "changeDescription", "rules", "teams", "roles", "location", "allowDelete", "allowEdit", "deleted", "provider", "disabled"})
public class Policy
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    @NotNull
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) @NotNull String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="Name that identifies a entity.")
    @Pattern(regexp="^(?U)[\\w'\\- .&]+$")
    @Size(min=1, max=128)
    private @Pattern(regexp="^(?U)[\\w'\\- .&]+$") @Size(min=1, max=128) String fullyQualifiedName;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display name for this Policy.")
    private String displayName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="owner")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference owner;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Is the policy enabled.")
    private Boolean enabled = true;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="rules")
    @JsonPropertyDescription(value="A set of rules associated with the Policy.")
    @Valid
    @NotNull
    private List<Rule> rules = new ArrayList<Rule>();
    @JsonProperty(value="teams")
    @Valid
    private List<EntityReference> teams = null;
    @JsonProperty(value="roles")
    @Valid
    private List<EntityReference> roles = null;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference location;
    @JsonProperty(value="allowDelete")
    @JsonPropertyDescription(value="Some system policies can't be deleted")
    private Boolean allowDelete;
    @JsonProperty(value="allowEdit")
    @JsonPropertyDescription(value="Some system roles can't be edited")
    private Boolean allowEdit;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="disabled")
    @JsonPropertyDescription(value="System policy can't be deleted. Use this flag to disable them.")
    private Boolean disabled;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public Policy withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Policy withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Policy withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Policy withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Policy withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="owner")
    public EntityReference getOwner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="owner")
    public void setOwner(EntityReference owner) {
        this.owner = owner;
    }

    public Policy withOwner(EntityReference owner) {
        this.owner = owner;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public Policy withHref(URI href) {
        this.href = href;
        return this;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Policy withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public Policy withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Policy withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Policy withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public Policy withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @JsonProperty(value="rules")
    public List<Rule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public Policy withRules(List<Rule> rules) {
        this.rules = rules;
        return this;
    }

    @JsonProperty(value="teams")
    public List<EntityReference> getTeams() {
        return this.teams;
    }

    @JsonProperty(value="teams")
    public void setTeams(List<EntityReference> teams) {
        this.teams = teams;
    }

    public Policy withTeams(List<EntityReference> teams) {
        this.teams = teams;
        return this;
    }

    @JsonProperty(value="roles")
    public List<EntityReference> getRoles() {
        return this.roles;
    }

    @JsonProperty(value="roles")
    public void setRoles(List<EntityReference> roles) {
        this.roles = roles;
    }

    public Policy withRoles(List<EntityReference> roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="location")
    public EntityReference getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(EntityReference location) {
        this.location = location;
    }

    public Policy withLocation(EntityReference location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="allowDelete")
    public Boolean getAllowDelete() {
        return this.allowDelete;
    }

    @JsonProperty(value="allowDelete")
    public void setAllowDelete(Boolean allowDelete) {
        this.allowDelete = allowDelete;
    }

    public Policy withAllowDelete(Boolean allowDelete) {
        this.allowDelete = allowDelete;
        return this;
    }

    @JsonProperty(value="allowEdit")
    public Boolean getAllowEdit() {
        return this.allowEdit;
    }

    @JsonProperty(value="allowEdit")
    public void setAllowEdit(Boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public Policy withAllowEdit(Boolean allowEdit) {
        this.allowEdit = allowEdit;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Policy withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public Policy withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    @JsonProperty(value="disabled")
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Policy withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Policy.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(this.owner == null ? "<null>" : this.owner);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        sb.append("teams");
        sb.append('=');
        sb.append(this.teams == null ? "<null>" : this.teams);
        sb.append(',');
        sb.append("roles");
        sb.append('=');
        sb.append(this.roles == null ? "<null>" : this.roles);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("allowDelete");
        sb.append('=');
        sb.append(this.allowDelete == null ? "<null>" : this.allowDelete);
        sb.append(',');
        sb.append("allowEdit");
        sb.append('=');
        sb.append(this.allowEdit == null ? "<null>" : this.allowEdit);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("disabled");
        sb.append('=');
        sb.append(this.disabled == null ? "<null>" : this.disabled);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        result = result * 31 + (this.allowDelete == null ? 0 : this.allowDelete.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.teams == null ? 0 : this.teams.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.roles == null ? 0 : this.roles.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.allowEdit == null ? 0 : this.allowEdit.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.disabled == null ? 0 : this.disabled.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Policy)) {
            return false;
        }
        Policy rhs = (Policy)other;
        return (this.owner == rhs.owner || this.owner != null && this.owner.equals(rhs.owner)) && (this.allowDelete == rhs.allowDelete || this.allowDelete != null && this.allowDelete.equals(rhs.allowDelete)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.teams == rhs.teams || this.teams != null && this.teams.equals(rhs.teams)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.roles == rhs.roles || this.roles != null && this.roles.equals(rhs.roles)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.allowEdit == rhs.allowEdit || this.allowEdit != null && this.allowEdit.equals(rhs.allowEdit)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.disabled == rhs.disabled || this.disabled != null && this.disabled.equals(rhs.disabled)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

