/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.policies.accessControl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.type.MetadataOperation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "fullyQualifiedName", "description", "effect", "operations", "resources", "condition"})
public class Rule {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of this Rule.")
    @NotNull
    private String name;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService:Database:Table'.")
    @Size(min=1, max=256)
    private @Size(min=1, max=256) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="effect")
    @NotNull
    private Effect effect;
    @JsonProperty(value="operations")
    @JsonPropertyDescription(value="List of operation names related to the `resources`. Use `*` to include all the operations.")
    @Valid
    @NotNull
    private List<MetadataOperation> operations = null;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources/objects related to this rule. Resources are typically `entityTypes` such as `table`, `database`, etc. It also includes `non-entityType` resources such as `lineage`. Use `*` to include all the resources.")
    @Valid
    @NotNull
    private List<String> resources = null;
    @JsonProperty(value="condition")
    @JsonPropertyDescription(value="Expression in SpEL.")
    private String condition;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Rule withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Rule withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Rule withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="effect")
    public Effect getEffect() {
        return this.effect;
    }

    @JsonProperty(value="effect")
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public Rule withEffect(Effect effect) {
        this.effect = effect;
        return this;
    }

    @JsonProperty(value="operations")
    public List<MetadataOperation> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="operations")
    public void setOperations(List<MetadataOperation> operations) {
        this.operations = operations;
    }

    public Rule withOperations(List<MetadataOperation> operations) {
        this.operations = operations;
        return this;
    }

    @JsonProperty(value="resources")
    public List<String> getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public Rule withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    @JsonProperty(value="condition")
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Rule withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Rule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("effect");
        sb.append('=');
        sb.append(this.effect == null ? "<null>" : this.effect);
        sb.append(',');
        sb.append("operations");
        sb.append('=');
        sb.append(this.operations == null ? "<null>" : this.operations);
        sb.append(',');
        sb.append("resources");
        sb.append('=');
        sb.append(this.resources == null ? "<null>" : this.resources);
        sb.append(',');
        sb.append("condition");
        sb.append('=');
        sb.append(this.condition == null ? "<null>" : this.condition);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.condition == null ? 0 : this.condition.hashCode());
        result = result * 31 + (this.operations == null ? 0 : this.operations.hashCode());
        result = result * 31 + (this.effect == null ? 0 : this.effect.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.resources == null ? 0 : this.resources.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rule)) {
            return false;
        }
        Rule rhs = (Rule)other;
        return (this.condition == rhs.condition || this.condition != null && this.condition.equals(rhs.condition)) && (this.operations == rhs.operations || this.operations != null && this.operations.equals(rhs.operations)) && (this.effect == rhs.effect || this.effect != null && this.effect.equals((Object)rhs.effect)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.resources == rhs.resources || this.resources != null && this.resources.equals(rhs.resources)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName));
    }

    public static enum Effect {
        ALLOW("allow"),
        DENY("deny");

        private final String value;
        private static final Map<String, Effect> CONSTANTS;

        private Effect(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Effect fromValue(String value) {
            Effect constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Effect>();
            for (Effect c : Effect.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

