/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.policies.lifecycle;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import org.openmetadata.schema.entity.data.Location;
import org.openmetadata.schema.entity.services.StorageService;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"storageServiceType", "storageClassType", "location"})
public class Destination {
    @JsonProperty(value="storageServiceType")
    @JsonPropertyDescription(value="This schema defines the Storage Service entity, such as S3, GCS, HDFS.")
    @Valid
    private StorageService storageServiceType;
    @JsonProperty(value="storageClassType")
    @JsonPropertyDescription(value="Type of storage class for the storage service.")
    private String storageClassType;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="This schema defines the Location entity. A Location can contain the data of a table or group other subLocation together.")
    @Valid
    private Location location;

    @JsonProperty(value="storageServiceType")
    public StorageService getStorageServiceType() {
        return this.storageServiceType;
    }

    @JsonProperty(value="storageServiceType")
    public void setStorageServiceType(StorageService storageServiceType) {
        this.storageServiceType = storageServiceType;
    }

    public Destination withStorageServiceType(StorageService storageServiceType) {
        this.storageServiceType = storageServiceType;
        return this;
    }

    @JsonProperty(value="storageClassType")
    public String getStorageClassType() {
        return this.storageClassType;
    }

    @JsonProperty(value="storageClassType")
    public void setStorageClassType(String storageClassType) {
        this.storageClassType = storageClassType;
    }

    public Destination withStorageClassType(String storageClassType) {
        this.storageClassType = storageClassType;
        return this;
    }

    @JsonProperty(value="location")
    public Location getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    public Destination withLocation(Location location) {
        this.location = location;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Destination.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("storageServiceType");
        sb.append('=');
        sb.append(this.storageServiceType == null ? "<null>" : this.storageServiceType);
        sb.append(',');
        sb.append("storageClassType");
        sb.append('=');
        sb.append(this.storageClassType == null ? "<null>" : this.storageClassType);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.storageServiceType == null ? 0 : this.storageServiceType.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.storageClassType == null ? 0 : this.storageClassType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Destination)) {
            return false;
        }
        Destination rhs = (Destination)other;
        return (this.storageServiceType == rhs.storageServiceType || this.storageServiceType != null && this.storageServiceType.equals(rhs.storageServiceType)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.storageClassType == rhs.storageClassType || this.storageClassType != null && this.storageClassType.equals(rhs.storageClassType));
    }
}

