/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.policies.lifecycle;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import org.openmetadata.schema.entity.policies.lifecycle.Destination;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"daysAfterCreation", "daysAfterModification", "destination"})
public class MoveAction {
    @JsonProperty(value="daysAfterCreation")
    @JsonPropertyDescription(value="Number of days after creation of the entity that the move should be triggered.")
    @DecimalMin(value="1")
    private @DecimalMin(value="1") Integer daysAfterCreation;
    @JsonProperty(value="daysAfterModification")
    @JsonPropertyDescription(value="Number of days after last modification of the entity that the move should be triggered.")
    @DecimalMin(value="1")
    private @DecimalMin(value="1") Integer daysAfterModification;
    @JsonProperty(value="destination")
    @JsonPropertyDescription(value="Location where this entity needs to be moved to.")
    @Valid
    private Destination destination;

    @JsonProperty(value="daysAfterCreation")
    public Integer getDaysAfterCreation() {
        return this.daysAfterCreation;
    }

    @JsonProperty(value="daysAfterCreation")
    public void setDaysAfterCreation(Integer daysAfterCreation) {
        this.daysAfterCreation = daysAfterCreation;
    }

    public MoveAction withDaysAfterCreation(Integer daysAfterCreation) {
        this.daysAfterCreation = daysAfterCreation;
        return this;
    }

    @JsonProperty(value="daysAfterModification")
    public Integer getDaysAfterModification() {
        return this.daysAfterModification;
    }

    @JsonProperty(value="daysAfterModification")
    public void setDaysAfterModification(Integer daysAfterModification) {
        this.daysAfterModification = daysAfterModification;
    }

    public MoveAction withDaysAfterModification(Integer daysAfterModification) {
        this.daysAfterModification = daysAfterModification;
        return this;
    }

    @JsonProperty(value="destination")
    public Destination getDestination() {
        return this.destination;
    }

    @JsonProperty(value="destination")
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public MoveAction withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MoveAction.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("daysAfterCreation");
        sb.append('=');
        sb.append(this.daysAfterCreation == null ? "<null>" : this.daysAfterCreation);
        sb.append(',');
        sb.append("daysAfterModification");
        sb.append('=');
        sb.append(this.daysAfterModification == null ? "<null>" : this.daysAfterModification);
        sb.append(',');
        sb.append("destination");
        sb.append('=');
        sb.append(this.destination == null ? "<null>" : this.destination);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.destination == null ? 0 : this.destination.hashCode());
        result = result * 31 + (this.daysAfterModification == null ? 0 : this.daysAfterModification.hashCode());
        result = result * 31 + (this.daysAfterCreation == null ? 0 : this.daysAfterCreation.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MoveAction)) {
            return false;
        }
        MoveAction rhs = (MoveAction)other;
        return (this.destination == rhs.destination || this.destination != null && this.destination.equals(rhs.destination)) && (this.daysAfterModification == rhs.daysAfterModification || this.daysAfterModification != null && this.daysAfterModification.equals(rhs.daysAfterModification)) && (this.daysAfterCreation == rhs.daysAfterCreation || this.daysAfterCreation != null && this.daysAfterCreation.equals(rhs.daysAfterCreation));
    }
}

