/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.policies.lifecycle;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "prefixFilter", "regexFilter", "tagsFilter", "actions"})
public class Rule {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies this Rule.")
    private String name;
    @JsonProperty(value="prefixFilter")
    @JsonPropertyDescription(value="Prefix path of the entity.")
    private String prefixFilter;
    @JsonProperty(value="regexFilter")
    @JsonPropertyDescription(value="Regex that matches the entity.")
    private String regexFilter;
    @JsonProperty(value="tagsFilter")
    @JsonPropertyDescription(value="Set of tags to match on (OR among all tags).")
    @Valid
    private List<String> tagsFilter = new ArrayList<String>();
    @JsonProperty(value="actions")
    @JsonPropertyDescription(value="A set of actions to take on the entities.")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<Object> actions = new ArrayList<Object>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Rule withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="prefixFilter")
    public String getPrefixFilter() {
        return this.prefixFilter;
    }

    @JsonProperty(value="prefixFilter")
    public void setPrefixFilter(String prefixFilter) {
        this.prefixFilter = prefixFilter;
    }

    public Rule withPrefixFilter(String prefixFilter) {
        this.prefixFilter = prefixFilter;
        return this;
    }

    @JsonProperty(value="regexFilter")
    public String getRegexFilter() {
        return this.regexFilter;
    }

    @JsonProperty(value="regexFilter")
    public void setRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
    }

    public Rule withRegexFilter(String regexFilter) {
        this.regexFilter = regexFilter;
        return this;
    }

    @JsonProperty(value="tagsFilter")
    public List<String> getTagsFilter() {
        return this.tagsFilter;
    }

    @JsonProperty(value="tagsFilter")
    public void setTagsFilter(List<String> tagsFilter) {
        this.tagsFilter = tagsFilter;
    }

    public Rule withTagsFilter(List<String> tagsFilter) {
        this.tagsFilter = tagsFilter;
        return this;
    }

    @JsonProperty(value="actions")
    public List<Object> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    public void setActions(List<Object> actions) {
        this.actions = actions;
    }

    public Rule withActions(List<Object> actions) {
        this.actions = actions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Rule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("prefixFilter");
        sb.append('=');
        sb.append(this.prefixFilter == null ? "<null>" : this.prefixFilter);
        sb.append(',');
        sb.append("regexFilter");
        sb.append('=');
        sb.append(this.regexFilter == null ? "<null>" : this.regexFilter);
        sb.append(',');
        sb.append("tagsFilter");
        sb.append('=');
        sb.append(this.tagsFilter == null ? "<null>" : this.tagsFilter);
        sb.append(',');
        sb.append("actions");
        sb.append('=');
        sb.append(this.actions == null ? "<null>" : this.actions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.prefixFilter == null ? 0 : this.prefixFilter.hashCode());
        result = result * 31 + (this.tagsFilter == null ? 0 : this.tagsFilter.hashCode());
        result = result * 31 + (this.regexFilter == null ? 0 : this.regexFilter.hashCode());
        result = result * 31 + (this.actions == null ? 0 : this.actions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rule)) {
            return false;
        }
        Rule rhs = (Rule)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.prefixFilter == rhs.prefixFilter || this.prefixFilter != null && this.prefixFilter.equals(rhs.prefixFilter)) && (this.tagsFilter == rhs.tagsFilter || this.tagsFilter != null && this.tagsFilter.equals(rhs.tagsFilter)) && (this.regexFilter == rhs.regexFilter || this.regexFilter != null && this.regexFilter.equals(rhs.regexFilter)) && (this.actions == rhs.actions || this.actions != null && this.actions.equals(rhs.actions));
    }
}

