/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.services.connections;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.entity.services.connections.TestConnectionResultStatus;
import org.openmetadata.schema.entity.services.connections.TestConnectionStepResult;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"lastUpdatedAt", "status", "steps"})
public class TestConnectionResult {
    @JsonProperty(value="lastUpdatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long lastUpdatedAt;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Enum defining possible Test Connection Result status")
    private TestConnectionResultStatus status;
    @JsonProperty(value="steps")
    @JsonPropertyDescription(value="Steps to test the connection. Order matters.")
    @Valid
    @NotNull
    private List<TestConnectionStepResult> steps = new ArrayList<TestConnectionStepResult>();

    @JsonProperty(value="lastUpdatedAt")
    public Long getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @JsonProperty(value="lastUpdatedAt")
    public void setLastUpdatedAt(Long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public TestConnectionResult withLastUpdatedAt(Long lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
        return this;
    }

    @JsonProperty(value="status")
    public TestConnectionResultStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(TestConnectionResultStatus status) {
        this.status = status;
    }

    public TestConnectionResult withStatus(TestConnectionResultStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="steps")
    public List<TestConnectionStepResult> getSteps() {
        return this.steps;
    }

    @JsonProperty(value="steps")
    public void setSteps(List<TestConnectionStepResult> steps) {
        this.steps = steps;
    }

    public TestConnectionResult withSteps(List<TestConnectionStepResult> steps) {
        this.steps = steps;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestConnectionResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("lastUpdatedAt");
        sb.append('=');
        sb.append(this.lastUpdatedAt == null ? "<null>" : this.lastUpdatedAt);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("steps");
        sb.append('=');
        sb.append(this.steps == null ? "<null>" : this.steps);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastUpdatedAt == null ? 0 : this.lastUpdatedAt.hashCode());
        result = result * 31 + (this.steps == null ? 0 : this.steps.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestConnectionResult)) {
            return false;
        }
        TestConnectionResult rhs = (TestConnectionResult)other;
        return (this.lastUpdatedAt == rhs.lastUpdatedAt || this.lastUpdatedAt != null && this.lastUpdatedAt.equals(rhs.lastUpdatedAt)) && (this.steps == rhs.steps || this.steps != null && this.steps.equals(rhs.steps)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

