/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.services.ingestionPipelines;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"pausePipeline", "concurrency", "startDate", "endDate", "pipelineTimezone", "retries", "retryDelay", "pipelineCatchup", "scheduleInterval", "maxActiveRuns", "workflowTimeout", "workflowDefaultView", "workflowDefaultViewOrientation", "email"})
public class AirflowConfig {
    @JsonProperty(value="pausePipeline")
    @JsonPropertyDescription(value="pause the pipeline from running once the deploy is finished successfully.")
    private Boolean pausePipeline = false;
    @JsonProperty(value="concurrency")
    @JsonPropertyDescription(value="Concurrency of the Pipeline.")
    private Integer concurrency = 1;
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'.")
    private Date startDate;
    @JsonProperty(value="endDate")
    @JsonPropertyDescription(value="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'.")
    private Date endDate;
    @JsonProperty(value="pipelineTimezone")
    @JsonPropertyDescription(value="Timezone in which pipeline going to be scheduled.")
    private String pipelineTimezone = "UTC";
    @JsonProperty(value="retries")
    @JsonPropertyDescription(value="Retry pipeline in case of failure.")
    private Integer retries = 3;
    @JsonProperty(value="retryDelay")
    @JsonPropertyDescription(value="Delay between retries in seconds.")
    private Integer retryDelay = 300;
    @JsonProperty(value="pipelineCatchup")
    @JsonPropertyDescription(value="Run past executions if the start date is in the past.")
    private Boolean pipelineCatchup = false;
    @JsonProperty(value="scheduleInterval")
    @JsonPropertyDescription(value="Scheduler Interval for the pipeline in cron format.")
    private String scheduleInterval;
    @JsonProperty(value="maxActiveRuns")
    @JsonPropertyDescription(value="Maximum Number of active runs.")
    private Integer maxActiveRuns = 1;
    @JsonProperty(value="workflowTimeout")
    @JsonPropertyDescription(value="Timeout for the workflow in seconds.")
    private Integer workflowTimeout = null;
    @JsonProperty(value="workflowDefaultView")
    @JsonPropertyDescription(value="Default view in Airflow.")
    private String workflowDefaultView = "tree";
    @JsonProperty(value="workflowDefaultViewOrientation")
    @JsonPropertyDescription(value="Default view Orientation in Airflow.")
    private String workflowDefaultViewOrientation = "LR";
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address of a user or other entities.")
    @Pattern(regexp="^\\S+@\\S+\\.\\S+$")
    @Size(min=6, max=127)
    private @Pattern(regexp="^\\S+@\\S+\\.\\S+$") @Size(min=6, max=127) String email;

    @JsonProperty(value="pausePipeline")
    public Boolean getPausePipeline() {
        return this.pausePipeline;
    }

    @JsonProperty(value="pausePipeline")
    public void setPausePipeline(Boolean pausePipeline) {
        this.pausePipeline = pausePipeline;
    }

    public AirflowConfig withPausePipeline(Boolean pausePipeline) {
        this.pausePipeline = pausePipeline;
        return this;
    }

    @JsonProperty(value="concurrency")
    public Integer getConcurrency() {
        return this.concurrency;
    }

    @JsonProperty(value="concurrency")
    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public AirflowConfig withConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public AirflowConfig withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public AirflowConfig withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty(value="pipelineTimezone")
    public String getPipelineTimezone() {
        return this.pipelineTimezone;
    }

    @JsonProperty(value="pipelineTimezone")
    public void setPipelineTimezone(String pipelineTimezone) {
        this.pipelineTimezone = pipelineTimezone;
    }

    public AirflowConfig withPipelineTimezone(String pipelineTimezone) {
        this.pipelineTimezone = pipelineTimezone;
        return this;
    }

    @JsonProperty(value="retries")
    public Integer getRetries() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public AirflowConfig withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @JsonProperty(value="retryDelay")
    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    @JsonProperty(value="retryDelay")
    public void setRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
    }

    public AirflowConfig withRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    @JsonProperty(value="pipelineCatchup")
    public Boolean getPipelineCatchup() {
        return this.pipelineCatchup;
    }

    @JsonProperty(value="pipelineCatchup")
    public void setPipelineCatchup(Boolean pipelineCatchup) {
        this.pipelineCatchup = pipelineCatchup;
    }

    public AirflowConfig withPipelineCatchup(Boolean pipelineCatchup) {
        this.pipelineCatchup = pipelineCatchup;
        return this;
    }

    @JsonProperty(value="scheduleInterval")
    public String getScheduleInterval() {
        return this.scheduleInterval;
    }

    @JsonProperty(value="scheduleInterval")
    public void setScheduleInterval(String scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
    }

    public AirflowConfig withScheduleInterval(String scheduleInterval) {
        this.scheduleInterval = scheduleInterval;
        return this;
    }

    @JsonProperty(value="maxActiveRuns")
    public Integer getMaxActiveRuns() {
        return this.maxActiveRuns;
    }

    @JsonProperty(value="maxActiveRuns")
    public void setMaxActiveRuns(Integer maxActiveRuns) {
        this.maxActiveRuns = maxActiveRuns;
    }

    public AirflowConfig withMaxActiveRuns(Integer maxActiveRuns) {
        this.maxActiveRuns = maxActiveRuns;
        return this;
    }

    @JsonProperty(value="workflowTimeout")
    public Integer getWorkflowTimeout() {
        return this.workflowTimeout;
    }

    @JsonProperty(value="workflowTimeout")
    public void setWorkflowTimeout(Integer workflowTimeout) {
        this.workflowTimeout = workflowTimeout;
    }

    public AirflowConfig withWorkflowTimeout(Integer workflowTimeout) {
        this.workflowTimeout = workflowTimeout;
        return this;
    }

    @JsonProperty(value="workflowDefaultView")
    public String getWorkflowDefaultView() {
        return this.workflowDefaultView;
    }

    @JsonProperty(value="workflowDefaultView")
    public void setWorkflowDefaultView(String workflowDefaultView) {
        this.workflowDefaultView = workflowDefaultView;
    }

    public AirflowConfig withWorkflowDefaultView(String workflowDefaultView) {
        this.workflowDefaultView = workflowDefaultView;
        return this;
    }

    @JsonProperty(value="workflowDefaultViewOrientation")
    public String getWorkflowDefaultViewOrientation() {
        return this.workflowDefaultViewOrientation;
    }

    @JsonProperty(value="workflowDefaultViewOrientation")
    public void setWorkflowDefaultViewOrientation(String workflowDefaultViewOrientation) {
        this.workflowDefaultViewOrientation = workflowDefaultViewOrientation;
    }

    public AirflowConfig withWorkflowDefaultViewOrientation(String workflowDefaultViewOrientation) {
        this.workflowDefaultViewOrientation = workflowDefaultViewOrientation;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public AirflowConfig withEmail(String email) {
        this.email = email;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AirflowConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("pausePipeline");
        sb.append('=');
        sb.append(this.pausePipeline == null ? "<null>" : this.pausePipeline);
        sb.append(',');
        sb.append("concurrency");
        sb.append('=');
        sb.append(this.concurrency == null ? "<null>" : this.concurrency);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("pipelineTimezone");
        sb.append('=');
        sb.append(this.pipelineTimezone == null ? "<null>" : this.pipelineTimezone);
        sb.append(',');
        sb.append("retries");
        sb.append('=');
        sb.append(this.retries == null ? "<null>" : this.retries);
        sb.append(',');
        sb.append("retryDelay");
        sb.append('=');
        sb.append(this.retryDelay == null ? "<null>" : this.retryDelay);
        sb.append(',');
        sb.append("pipelineCatchup");
        sb.append('=');
        sb.append(this.pipelineCatchup == null ? "<null>" : this.pipelineCatchup);
        sb.append(',');
        sb.append("scheduleInterval");
        sb.append('=');
        sb.append(this.scheduleInterval == null ? "<null>" : this.scheduleInterval);
        sb.append(',');
        sb.append("maxActiveRuns");
        sb.append('=');
        sb.append(this.maxActiveRuns == null ? "<null>" : this.maxActiveRuns);
        sb.append(',');
        sb.append("workflowTimeout");
        sb.append('=');
        sb.append(this.workflowTimeout == null ? "<null>" : this.workflowTimeout);
        sb.append(',');
        sb.append("workflowDefaultView");
        sb.append('=');
        sb.append(this.workflowDefaultView == null ? "<null>" : this.workflowDefaultView);
        sb.append(',');
        sb.append("workflowDefaultViewOrientation");
        sb.append('=');
        sb.append(this.workflowDefaultViewOrientation == null ? "<null>" : this.workflowDefaultViewOrientation);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.maxActiveRuns == null ? 0 : this.maxActiveRuns.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.pipelineCatchup == null ? 0 : this.pipelineCatchup.hashCode());
        result = result * 31 + (this.pausePipeline == null ? 0 : this.pausePipeline.hashCode());
        result = result * 31 + (this.pipelineTimezone == null ? 0 : this.pipelineTimezone.hashCode());
        result = result * 31 + (this.concurrency == null ? 0 : this.concurrency.hashCode());
        result = result * 31 + (this.retryDelay == null ? 0 : this.retryDelay.hashCode());
        result = result * 31 + (this.scheduleInterval == null ? 0 : this.scheduleInterval.hashCode());
        result = result * 31 + (this.retries == null ? 0 : this.retries.hashCode());
        result = result * 31 + (this.workflowDefaultViewOrientation == null ? 0 : this.workflowDefaultViewOrientation.hashCode());
        result = result * 31 + (this.workflowDefaultView == null ? 0 : this.workflowDefaultView.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.workflowTimeout == null ? 0 : this.workflowTimeout.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AirflowConfig)) {
            return false;
        }
        AirflowConfig rhs = (AirflowConfig)other;
        return (this.maxActiveRuns == rhs.maxActiveRuns || this.maxActiveRuns != null && this.maxActiveRuns.equals(rhs.maxActiveRuns)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.pipelineCatchup == rhs.pipelineCatchup || this.pipelineCatchup != null && this.pipelineCatchup.equals(rhs.pipelineCatchup)) && (this.pausePipeline == rhs.pausePipeline || this.pausePipeline != null && this.pausePipeline.equals(rhs.pausePipeline)) && (this.pipelineTimezone == rhs.pipelineTimezone || this.pipelineTimezone != null && this.pipelineTimezone.equals(rhs.pipelineTimezone)) && (this.concurrency == rhs.concurrency || this.concurrency != null && this.concurrency.equals(rhs.concurrency)) && (this.retryDelay == rhs.retryDelay || this.retryDelay != null && this.retryDelay.equals(rhs.retryDelay)) && (this.scheduleInterval == rhs.scheduleInterval || this.scheduleInterval != null && this.scheduleInterval.equals(rhs.scheduleInterval)) && (this.retries == rhs.retries || this.retries != null && this.retries.equals(rhs.retries)) && (this.workflowDefaultViewOrientation == rhs.workflowDefaultViewOrientation || this.workflowDefaultViewOrientation != null && this.workflowDefaultViewOrientation.equals(rhs.workflowDefaultViewOrientation)) && (this.workflowDefaultView == rhs.workflowDefaultView || this.workflowDefaultView != null && this.workflowDefaultView.equals(rhs.workflowDefaultView)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.workflowTimeout == rhs.workflowTimeout || this.workflowTimeout != null && this.workflowTimeout.equals(rhs.workflowTimeout)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email));
    }
}

