/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.teams;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"config", "authType"})
public class AuthenticationMechanism {
    @JsonProperty(value="config")
    private Object config;
    @JsonProperty(value="authType")
    private AuthType authType;

    @JsonProperty(value="config")
    public Object getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    public void setConfig(Object config) {
        this.config = config;
    }

    public AuthenticationMechanism withConfig(Object config) {
        this.config = config;
        return this;
    }

    @JsonProperty(value="authType")
    public AuthType getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="authType")
    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public AuthenticationMechanism withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthenticationMechanism.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("config");
        sb.append('=');
        sb.append(this.config == null ? "<null>" : this.config);
        sb.append(',');
        sb.append("authType");
        sb.append('=');
        sb.append(this.authType == null ? "<null>" : this.authType);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.authType == null ? 0 : this.authType.hashCode());
        result = result * 31 + (this.config == null ? 0 : this.config.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthenticationMechanism)) {
            return false;
        }
        AuthenticationMechanism rhs = (AuthenticationMechanism)other;
        return (this.authType == rhs.authType || this.authType != null && this.authType.equals((Object)rhs.authType)) && (this.config == rhs.config || this.config != null && this.config.equals(rhs.config));
    }

    public static enum AuthType {
        JWT("JWT"),
        SSO("SSO"),
        BASIC("BASIC");

        private final String value;
        private static final Map<String, AuthType> CONSTANTS;

        private AuthType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AuthType fromValue(String value) {
            AuthType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AuthType>();
            for (AuthType c : AuthType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

