/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.entity.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.openmetadata.annotations.PasswordField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"provider", "username", "password"})
public class SupersetApiConnection {
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Authentication provider for the Superset service. For basic user/password authentication, the default value `db` can be used. This parameter is used internally to connect to Superset's REST API.")
    @NotNull
    private ApiProvider provider = ApiProvider.fromValue("db");
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="Username for Superset.")
    @NotNull
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password for Superset.")
    @PasswordField
    @NotNull
    private String password;

    @JsonProperty(value="provider")
    public ApiProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ApiProvider provider) {
        this.provider = provider;
    }

    public SupersetApiConnection withProvider(ApiProvider provider) {
        this.provider = provider;
        return this;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public SupersetApiConnection withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    @PasswordField
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @PasswordField
    public void setPassword(String password) {
        this.password = password;
    }

    public SupersetApiConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SupersetApiConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SupersetApiConnection)) {
            return false;
        }
        SupersetApiConnection rhs = (SupersetApiConnection)other;
        return (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }

    public static enum ApiProvider {
        DB("db"),
        LDAP("ldap");

        private final String value;
        private static final Map<String, ApiProvider> CONSTANTS;

        private ApiProvider(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ApiProvider fromValue(String value) {
            ApiProvider constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ApiProvider>();
            for (ApiProvider c : ApiProvider.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

