/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "markDeletedTables", "markAllDeletedTables", "includeTables", "includeViews", "includeTags", "useFqnForFiltering", "schemaFilterPattern", "tableFilterPattern", "databaseFilterPattern"})
public class DatabaseServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Database Source Config Metadata Pipeline type")
    private DatabaseMetadataConfigType type = DatabaseMetadataConfigType.fromValue("DatabaseMetadata");
    @JsonProperty(value="markDeletedTables")
    @JsonPropertyDescription(value="This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply solely to the schema that is currently being ingested via the pipeline. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted.")
    private Boolean markDeletedTables = true;
    @JsonProperty(value="markAllDeletedTables")
    @JsonPropertyDescription(value="This is an optional configuration for enabling soft deletion of tables. When this option is enabled, only tables that have been deleted from the source will be soft deleted, and this will apply to all the schemas available in the data source. Any related entities such as test suites or lineage information that were associated with those tables will also be deleted. Do not enable this option when you have multiple metadata ingestion pipelines. Also make sure to enable the markDeletedTables option for this to work.")
    private Boolean markAllDeletedTables = false;
    @JsonProperty(value="includeTables")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching metadata for tables.")
    private Boolean includeTables = true;
    @JsonProperty(value="includeViews")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching metadata for views.")
    private Boolean includeViews = true;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = true;
    @JsonProperty(value="useFqnForFiltering")
    @JsonPropertyDescription(value="Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)")
    private Boolean useFqnForFiltering = false;
    @JsonProperty(value="schemaFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern schemaFilterPattern;
    @JsonProperty(value="tableFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern tableFilterPattern;
    @JsonProperty(value="databaseFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern databaseFilterPattern;

    @JsonProperty(value="type")
    public DatabaseMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DatabaseMetadataConfigType type) {
        this.type = type;
    }

    public DatabaseServiceMetadataPipeline withType(DatabaseMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="markDeletedTables")
    public Boolean getMarkDeletedTables() {
        return this.markDeletedTables;
    }

    @JsonProperty(value="markDeletedTables")
    public void setMarkDeletedTables(Boolean markDeletedTables) {
        this.markDeletedTables = markDeletedTables;
    }

    public DatabaseServiceMetadataPipeline withMarkDeletedTables(Boolean markDeletedTables) {
        this.markDeletedTables = markDeletedTables;
        return this;
    }

    @JsonProperty(value="markAllDeletedTables")
    public Boolean getMarkAllDeletedTables() {
        return this.markAllDeletedTables;
    }

    @JsonProperty(value="markAllDeletedTables")
    public void setMarkAllDeletedTables(Boolean markAllDeletedTables) {
        this.markAllDeletedTables = markAllDeletedTables;
    }

    public DatabaseServiceMetadataPipeline withMarkAllDeletedTables(Boolean markAllDeletedTables) {
        this.markAllDeletedTables = markAllDeletedTables;
        return this;
    }

    @JsonProperty(value="includeTables")
    public Boolean getIncludeTables() {
        return this.includeTables;
    }

    @JsonProperty(value="includeTables")
    public void setIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
    }

    public DatabaseServiceMetadataPipeline withIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    @JsonProperty(value="includeViews")
    public Boolean getIncludeViews() {
        return this.includeViews;
    }

    @JsonProperty(value="includeViews")
    public void setIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
    }

    public DatabaseServiceMetadataPipeline withIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public DatabaseServiceMetadataPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @JsonProperty(value="useFqnForFiltering")
    public Boolean getUseFqnForFiltering() {
        return this.useFqnForFiltering;
    }

    @JsonProperty(value="useFqnForFiltering")
    public void setUseFqnForFiltering(Boolean useFqnForFiltering) {
        this.useFqnForFiltering = useFqnForFiltering;
    }

    public DatabaseServiceMetadataPipeline withUseFqnForFiltering(Boolean useFqnForFiltering) {
        this.useFqnForFiltering = useFqnForFiltering;
        return this;
    }

    @JsonProperty(value="schemaFilterPattern")
    public FilterPattern getSchemaFilterPattern() {
        return this.schemaFilterPattern;
    }

    @JsonProperty(value="schemaFilterPattern")
    public void setSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
    }

    public DatabaseServiceMetadataPipeline withSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
        return this;
    }

    @JsonProperty(value="tableFilterPattern")
    public FilterPattern getTableFilterPattern() {
        return this.tableFilterPattern;
    }

    @JsonProperty(value="tableFilterPattern")
    public void setTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
    }

    public DatabaseServiceMetadataPipeline withTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
        return this;
    }

    @JsonProperty(value="databaseFilterPattern")
    public FilterPattern getDatabaseFilterPattern() {
        return this.databaseFilterPattern;
    }

    @JsonProperty(value="databaseFilterPattern")
    public void setDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
    }

    public DatabaseServiceMetadataPipeline withDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("markDeletedTables");
        sb.append('=');
        sb.append(this.markDeletedTables == null ? "<null>" : this.markDeletedTables);
        sb.append(',');
        sb.append("markAllDeletedTables");
        sb.append('=');
        sb.append(this.markAllDeletedTables == null ? "<null>" : this.markAllDeletedTables);
        sb.append(',');
        sb.append("includeTables");
        sb.append('=');
        sb.append(this.includeTables == null ? "<null>" : this.includeTables);
        sb.append(',');
        sb.append("includeViews");
        sb.append('=');
        sb.append(this.includeViews == null ? "<null>" : this.includeViews);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        sb.append("useFqnForFiltering");
        sb.append('=');
        sb.append(this.useFqnForFiltering == null ? "<null>" : this.useFqnForFiltering);
        sb.append(',');
        sb.append("schemaFilterPattern");
        sb.append('=');
        sb.append(this.schemaFilterPattern == null ? "<null>" : this.schemaFilterPattern);
        sb.append(',');
        sb.append("tableFilterPattern");
        sb.append('=');
        sb.append(this.tableFilterPattern == null ? "<null>" : this.tableFilterPattern);
        sb.append(',');
        sb.append("databaseFilterPattern");
        sb.append('=');
        sb.append(this.databaseFilterPattern == null ? "<null>" : this.databaseFilterPattern);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.includeTables == null ? 0 : this.includeTables.hashCode());
        result = result * 31 + (this.includeViews == null ? 0 : this.includeViews.hashCode());
        result = result * 31 + (this.tableFilterPattern == null ? 0 : this.tableFilterPattern.hashCode());
        result = result * 31 + (this.schemaFilterPattern == null ? 0 : this.schemaFilterPattern.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        result = result * 31 + (this.useFqnForFiltering == null ? 0 : this.useFqnForFiltering.hashCode());
        result = result * 31 + (this.databaseFilterPattern == null ? 0 : this.databaseFilterPattern.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.markAllDeletedTables == null ? 0 : this.markAllDeletedTables.hashCode());
        result = result * 31 + (this.markDeletedTables == null ? 0 : this.markDeletedTables.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseServiceMetadataPipeline)) {
            return false;
        }
        DatabaseServiceMetadataPipeline rhs = (DatabaseServiceMetadataPipeline)other;
        return (this.includeTables == rhs.includeTables || this.includeTables != null && this.includeTables.equals(rhs.includeTables)) && (this.includeViews == rhs.includeViews || this.includeViews != null && this.includeViews.equals(rhs.includeViews)) && (this.tableFilterPattern == rhs.tableFilterPattern || this.tableFilterPattern != null && this.tableFilterPattern.equals(rhs.tableFilterPattern)) && (this.schemaFilterPattern == rhs.schemaFilterPattern || this.schemaFilterPattern != null && this.schemaFilterPattern.equals(rhs.schemaFilterPattern)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags)) && (this.useFqnForFiltering == rhs.useFqnForFiltering || this.useFqnForFiltering != null && this.useFqnForFiltering.equals(rhs.useFqnForFiltering)) && (this.databaseFilterPattern == rhs.databaseFilterPattern || this.databaseFilterPattern != null && this.databaseFilterPattern.equals(rhs.databaseFilterPattern)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.markAllDeletedTables == rhs.markAllDeletedTables || this.markAllDeletedTables != null && this.markAllDeletedTables.equals(rhs.markAllDeletedTables)) && (this.markDeletedTables == rhs.markDeletedTables || this.markDeletedTables != null && this.markDeletedTables.equals(rhs.markDeletedTables));
    }

    public static enum DatabaseMetadataConfigType {
        DATABASE_METADATA("DatabaseMetadata");

        private final String value;
        private static final Map<String, DatabaseMetadataConfigType> CONSTANTS;

        private DatabaseMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseMetadataConfigType fromValue(String value) {
            DatabaseMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DatabaseMetadataConfigType>();
            for (DatabaseMetadataConfigType c : DatabaseMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

