/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.annotations.MaskedField;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "dbtConfigSource", "dbtUpdateDescriptions", "includeTags", "dbtClassificationName"})
public class DbtPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="DBT Config Pipeline type")
    private DbtConfigType type = DbtConfigType.fromValue("DBT");
    @JsonProperty(value="dbtConfigSource")
    @JsonPropertyDescription(value="Available sources to fetch DBT catalog and manifest files.")
    @MaskedField
    private Object dbtConfigSource;
    @JsonProperty(value="dbtUpdateDescriptions")
    @JsonPropertyDescription(value="Optional configuration to update the description from DBT or not")
    private Boolean dbtUpdateDescriptions = false;
    @JsonProperty(value="includeTags")
    @JsonPropertyDescription(value="Optional configuration to toggle the tags ingestion.")
    private Boolean includeTags = true;
    @JsonProperty(value="dbtClassificationName")
    @JsonPropertyDescription(value="Custom OpenMetadata Classification name for dbt tags.")
    private String dbtClassificationName = "dbtTags";

    @JsonProperty(value="type")
    public DbtConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(DbtConfigType type) {
        this.type = type;
    }

    public DbtPipeline withType(DbtConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="dbtConfigSource")
    @MaskedField
    public Object getDbtConfigSource() {
        return this.dbtConfigSource;
    }

    @JsonProperty(value="dbtConfigSource")
    @MaskedField
    public void setDbtConfigSource(Object dbtConfigSource) {
        this.dbtConfigSource = dbtConfigSource;
    }

    public DbtPipeline withDbtConfigSource(Object dbtConfigSource) {
        this.dbtConfigSource = dbtConfigSource;
        return this;
    }

    @JsonProperty(value="dbtUpdateDescriptions")
    public Boolean getDbtUpdateDescriptions() {
        return this.dbtUpdateDescriptions;
    }

    @JsonProperty(value="dbtUpdateDescriptions")
    public void setDbtUpdateDescriptions(Boolean dbtUpdateDescriptions) {
        this.dbtUpdateDescriptions = dbtUpdateDescriptions;
    }

    public DbtPipeline withDbtUpdateDescriptions(Boolean dbtUpdateDescriptions) {
        this.dbtUpdateDescriptions = dbtUpdateDescriptions;
        return this;
    }

    @JsonProperty(value="includeTags")
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public DbtPipeline withIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @JsonProperty(value="dbtClassificationName")
    public String getDbtClassificationName() {
        return this.dbtClassificationName;
    }

    @JsonProperty(value="dbtClassificationName")
    public void setDbtClassificationName(String dbtClassificationName) {
        this.dbtClassificationName = dbtClassificationName;
    }

    public DbtPipeline withDbtClassificationName(String dbtClassificationName) {
        this.dbtClassificationName = dbtClassificationName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbtPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("dbtConfigSource");
        sb.append('=');
        sb.append(this.dbtConfigSource == null ? "<null>" : this.dbtConfigSource);
        sb.append(',');
        sb.append("dbtUpdateDescriptions");
        sb.append('=');
        sb.append(this.dbtUpdateDescriptions == null ? "<null>" : this.dbtUpdateDescriptions);
        sb.append(',');
        sb.append("includeTags");
        sb.append('=');
        sb.append(this.includeTags == null ? "<null>" : this.includeTags);
        sb.append(',');
        sb.append("dbtClassificationName");
        sb.append('=');
        sb.append(this.dbtClassificationName == null ? "<null>" : this.dbtClassificationName);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dbtUpdateDescriptions == null ? 0 : this.dbtUpdateDescriptions.hashCode());
        result = result * 31 + (this.dbtConfigSource == null ? 0 : this.dbtConfigSource.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.dbtClassificationName == null ? 0 : this.dbtClassificationName.hashCode());
        result = result * 31 + (this.includeTags == null ? 0 : this.includeTags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DbtPipeline)) {
            return false;
        }
        DbtPipeline rhs = (DbtPipeline)other;
        return (this.dbtUpdateDescriptions == rhs.dbtUpdateDescriptions || this.dbtUpdateDescriptions != null && this.dbtUpdateDescriptions.equals(rhs.dbtUpdateDescriptions)) && (this.dbtConfigSource == rhs.dbtConfigSource || this.dbtConfigSource != null && this.dbtConfigSource.equals(rhs.dbtConfigSource)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.dbtClassificationName == rhs.dbtClassificationName || this.dbtClassificationName != null && this.dbtClassificationName.equals(rhs.dbtClassificationName)) && (this.includeTags == rhs.includeTags || this.includeTags != null && this.includeTags.equals(rhs.includeTags));
    }

    public static enum DbtConfigType {
        DBT("DBT");

        private final String value;
        private static final Map<String, DbtConfigType> CONSTANTS;

        private DbtConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DbtConfigType fromValue(String value) {
            DbtConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DbtConfigType>();
            for (DbtConfigType c : DbtConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

