/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "mlModelFilterPattern", "markDeletedMlModels"})
public class MlmodelServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="MlModel Source Config Metadata Pipeline type")
    private MlModelMetadataConfigType type = MlModelMetadataConfigType.fromValue("MlModelMetadata");
    @JsonProperty(value="mlModelFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern mlModelFilterPattern;
    @JsonProperty(value="markDeletedMlModels")
    @JsonPropertyDescription(value="Optional configuration to soft delete MlModels in OpenMetadata if the source MlModels are deleted. Also, if the MlModel is deleted, all the associated entities like lineage, etc., with that MlModels will be deleted")
    private Boolean markDeletedMlModels = true;

    @JsonProperty(value="type")
    public MlModelMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(MlModelMetadataConfigType type) {
        this.type = type;
    }

    public MlmodelServiceMetadataPipeline withType(MlModelMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="mlModelFilterPattern")
    public FilterPattern getMlModelFilterPattern() {
        return this.mlModelFilterPattern;
    }

    @JsonProperty(value="mlModelFilterPattern")
    public void setMlModelFilterPattern(FilterPattern mlModelFilterPattern) {
        this.mlModelFilterPattern = mlModelFilterPattern;
    }

    public MlmodelServiceMetadataPipeline withMlModelFilterPattern(FilterPattern mlModelFilterPattern) {
        this.mlModelFilterPattern = mlModelFilterPattern;
        return this;
    }

    @JsonProperty(value="markDeletedMlModels")
    public Boolean getMarkDeletedMlModels() {
        return this.markDeletedMlModels;
    }

    @JsonProperty(value="markDeletedMlModels")
    public void setMarkDeletedMlModels(Boolean markDeletedMlModels) {
        this.markDeletedMlModels = markDeletedMlModels;
    }

    public MlmodelServiceMetadataPipeline withMarkDeletedMlModels(Boolean markDeletedMlModels) {
        this.markDeletedMlModels = markDeletedMlModels;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MlmodelServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("mlModelFilterPattern");
        sb.append('=');
        sb.append(this.mlModelFilterPattern == null ? "<null>" : this.mlModelFilterPattern);
        sb.append(',');
        sb.append("markDeletedMlModels");
        sb.append('=');
        sb.append(this.markDeletedMlModels == null ? "<null>" : this.markDeletedMlModels);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.markDeletedMlModels == null ? 0 : this.markDeletedMlModels.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.mlModelFilterPattern == null ? 0 : this.mlModelFilterPattern.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MlmodelServiceMetadataPipeline)) {
            return false;
        }
        MlmodelServiceMetadataPipeline rhs = (MlmodelServiceMetadataPipeline)other;
        return (this.markDeletedMlModels == rhs.markDeletedMlModels || this.markDeletedMlModels != null && this.markDeletedMlModels.equals(rhs.markDeletedMlModels)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.mlModelFilterPattern == rhs.mlModelFilterPattern || this.mlModelFilterPattern != null && this.mlModelFilterPattern.equals(rhs.mlModelFilterPattern));
    }

    public static enum MlModelMetadataConfigType {
        ML_MODEL_METADATA("MlModelMetadata");

        private final String value;
        private static final Map<String, MlModelMetadataConfigType> CONSTANTS;

        private MlModelMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MlModelMetadataConfigType fromValue(String value) {
            MlModelMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MlModelMetadataConfigType>();
            for (MlModelMetadataConfigType c : MlModelMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

