/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.FilterPattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "containerFilterPattern"})
public class ObjectstoreServiceMetadataPipeline {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Object Store Source Config Metadata Pipeline type")
    private ObjectstoreMetadataConfigType type = ObjectstoreMetadataConfigType.fromValue("ObjectStoreMetadata");
    @JsonProperty(value="containerFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch dashboards or charts that matches the pattern.")
    @Valid
    private FilterPattern containerFilterPattern;

    @JsonProperty(value="type")
    public ObjectstoreMetadataConfigType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(ObjectstoreMetadataConfigType type) {
        this.type = type;
    }

    public ObjectstoreServiceMetadataPipeline withType(ObjectstoreMetadataConfigType type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="containerFilterPattern")
    public FilterPattern getContainerFilterPattern() {
        return this.containerFilterPattern;
    }

    @JsonProperty(value="containerFilterPattern")
    public void setContainerFilterPattern(FilterPattern containerFilterPattern) {
        this.containerFilterPattern = containerFilterPattern;
    }

    public ObjectstoreServiceMetadataPipeline withContainerFilterPattern(FilterPattern containerFilterPattern) {
        this.containerFilterPattern = containerFilterPattern;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ObjectstoreServiceMetadataPipeline.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("containerFilterPattern");
        sb.append('=');
        sb.append(this.containerFilterPattern == null ? "<null>" : this.containerFilterPattern);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.containerFilterPattern == null ? 0 : this.containerFilterPattern.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ObjectstoreServiceMetadataPipeline)) {
            return false;
        }
        ObjectstoreServiceMetadataPipeline rhs = (ObjectstoreServiceMetadataPipeline)other;
        return (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.containerFilterPattern == rhs.containerFilterPattern || this.containerFilterPattern != null && this.containerFilterPattern.equals(rhs.containerFilterPattern));
    }

    public static enum ObjectstoreMetadataConfigType {
        OBJECT_STORE_METADATA("ObjectStoreMetadata");

        private final String value;
        private static final Map<String, ObjectstoreMetadataConfigType> CONSTANTS;

        private ObjectstoreMetadataConfigType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ObjectstoreMetadataConfigType fromValue(String value) {
            ObjectstoreMetadataConfigType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ObjectstoreMetadataConfigType>();
            for (ObjectstoreMetadataConfigType c : ObjectstoreMetadataConfigType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

