/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.dbtconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dbtCatalogHttpPath", "dbtManifestHttpPath", "dbtRunResultsHttpPath"})
public class DbtHttpConfig {
    @JsonProperty(value="dbtCatalogHttpPath")
    @JsonPropertyDescription(value="DBT catalog http file path to extract dbt models with their column schemas.")
    private String dbtCatalogHttpPath;
    @JsonProperty(value="dbtManifestHttpPath")
    @JsonPropertyDescription(value="DBT manifest http file path to extract dbt models and associate with tables.")
    @NotNull
    private String dbtManifestHttpPath;
    @JsonProperty(value="dbtRunResultsHttpPath")
    @JsonPropertyDescription(value="DBT run results http file path to extract the test results information.")
    private String dbtRunResultsHttpPath;

    @JsonProperty(value="dbtCatalogHttpPath")
    public String getDbtCatalogHttpPath() {
        return this.dbtCatalogHttpPath;
    }

    @JsonProperty(value="dbtCatalogHttpPath")
    public void setDbtCatalogHttpPath(String dbtCatalogHttpPath) {
        this.dbtCatalogHttpPath = dbtCatalogHttpPath;
    }

    public DbtHttpConfig withDbtCatalogHttpPath(String dbtCatalogHttpPath) {
        this.dbtCatalogHttpPath = dbtCatalogHttpPath;
        return this;
    }

    @JsonProperty(value="dbtManifestHttpPath")
    public String getDbtManifestHttpPath() {
        return this.dbtManifestHttpPath;
    }

    @JsonProperty(value="dbtManifestHttpPath")
    public void setDbtManifestHttpPath(String dbtManifestHttpPath) {
        this.dbtManifestHttpPath = dbtManifestHttpPath;
    }

    public DbtHttpConfig withDbtManifestHttpPath(String dbtManifestHttpPath) {
        this.dbtManifestHttpPath = dbtManifestHttpPath;
        return this;
    }

    @JsonProperty(value="dbtRunResultsHttpPath")
    public String getDbtRunResultsHttpPath() {
        return this.dbtRunResultsHttpPath;
    }

    @JsonProperty(value="dbtRunResultsHttpPath")
    public void setDbtRunResultsHttpPath(String dbtRunResultsHttpPath) {
        this.dbtRunResultsHttpPath = dbtRunResultsHttpPath;
    }

    public DbtHttpConfig withDbtRunResultsHttpPath(String dbtRunResultsHttpPath) {
        this.dbtRunResultsHttpPath = dbtRunResultsHttpPath;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbtHttpConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dbtCatalogHttpPath");
        sb.append('=');
        sb.append(this.dbtCatalogHttpPath == null ? "<null>" : this.dbtCatalogHttpPath);
        sb.append(',');
        sb.append("dbtManifestHttpPath");
        sb.append('=');
        sb.append(this.dbtManifestHttpPath == null ? "<null>" : this.dbtManifestHttpPath);
        sb.append(',');
        sb.append("dbtRunResultsHttpPath");
        sb.append('=');
        sb.append(this.dbtRunResultsHttpPath == null ? "<null>" : this.dbtRunResultsHttpPath);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dbtManifestHttpPath == null ? 0 : this.dbtManifestHttpPath.hashCode());
        result = result * 31 + (this.dbtCatalogHttpPath == null ? 0 : this.dbtCatalogHttpPath.hashCode());
        result = result * 31 + (this.dbtRunResultsHttpPath == null ? 0 : this.dbtRunResultsHttpPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DbtHttpConfig)) {
            return false;
        }
        DbtHttpConfig rhs = (DbtHttpConfig)other;
        return (this.dbtManifestHttpPath == rhs.dbtManifestHttpPath || this.dbtManifestHttpPath != null && this.dbtManifestHttpPath.equals(rhs.dbtManifestHttpPath)) && (this.dbtCatalogHttpPath == rhs.dbtCatalogHttpPath || this.dbtCatalogHttpPath != null && this.dbtCatalogHttpPath.equals(rhs.dbtCatalogHttpPath)) && (this.dbtRunResultsHttpPath == rhs.dbtRunResultsHttpPath || this.dbtRunResultsHttpPath != null && this.dbtRunResultsHttpPath.equals(rhs.dbtRunResultsHttpPath));
    }
}

