/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.dbtconfig;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtBucketDetails;
import org.openmetadata.schema.security.credentials.AWSCredentials;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dbtSecurityConfig", "dbtPrefixConfig"})
public class DbtS3Config {
    @JsonProperty(value="dbtSecurityConfig")
    @JsonPropertyDescription(value="AWS credentials configs.")
    @Valid
    private AWSCredentials dbtSecurityConfig;
    @JsonProperty(value="dbtPrefixConfig")
    @JsonPropertyDescription(value="Details of the bucket where the dbt files are stored")
    @Valid
    private DbtBucketDetails dbtPrefixConfig;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="dbtSecurityConfig")
    public AWSCredentials getDbtSecurityConfig() {
        return this.dbtSecurityConfig;
    }

    @JsonProperty(value="dbtSecurityConfig")
    public void setDbtSecurityConfig(AWSCredentials dbtSecurityConfig) {
        this.dbtSecurityConfig = dbtSecurityConfig;
    }

    public DbtS3Config withDbtSecurityConfig(AWSCredentials dbtSecurityConfig) {
        this.dbtSecurityConfig = dbtSecurityConfig;
        return this;
    }

    @JsonProperty(value="dbtPrefixConfig")
    public DbtBucketDetails getDbtPrefixConfig() {
        return this.dbtPrefixConfig;
    }

    @JsonProperty(value="dbtPrefixConfig")
    public void setDbtPrefixConfig(DbtBucketDetails dbtPrefixConfig) {
        this.dbtPrefixConfig = dbtPrefixConfig;
    }

    public DbtS3Config withDbtPrefixConfig(DbtBucketDetails dbtPrefixConfig) {
        this.dbtPrefixConfig = dbtPrefixConfig;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DbtS3Config withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbtS3Config.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dbtSecurityConfig");
        sb.append('=');
        sb.append(this.dbtSecurityConfig == null ? "<null>" : this.dbtSecurityConfig);
        sb.append(',');
        sb.append("dbtPrefixConfig");
        sb.append('=');
        sb.append(this.dbtPrefixConfig == null ? "<null>" : this.dbtPrefixConfig);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dbtPrefixConfig == null ? 0 : this.dbtPrefixConfig.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.dbtSecurityConfig == null ? 0 : this.dbtSecurityConfig.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DbtS3Config)) {
            return false;
        }
        DbtS3Config rhs = (DbtS3Config)other;
        return (this.dbtPrefixConfig == rhs.dbtPrefixConfig || this.dbtPrefixConfig != null && this.dbtPrefixConfig.equals(rhs.dbtPrefixConfig)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.dbtSecurityConfig == rhs.dbtSecurityConfig || this.dbtSecurityConfig != null && this.dbtSecurityConfig.equals(rhs.dbtSecurityConfig));
    }
}

