/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.metadataIngestion.objectstore;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dataPath", "structureFormat", "isPartitioned", "partitionColumn"})
public class ContainerMetadataEntry {
    @JsonProperty(value="dataPath")
    @JsonPropertyDescription(value="The path where the data resides in the container, excluding the bucket name")
    @NotNull
    private String dataPath;
    @JsonProperty(value="structureFormat")
    @JsonPropertyDescription(value="What's the schema format for the container, eg. avro, parquet, csv.")
    private String structureFormat = null;
    @JsonProperty(value="isPartitioned")
    @JsonPropertyDescription(value="Flag indicating whether the container's data is partitioned")
    private Boolean isPartitioned = false;
    @JsonProperty(value="partitionColumn")
    @JsonPropertyDescription(value="What is the partition column in case the container's data is partitioned")
    private String partitionColumn = null;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="dataPath")
    public String getDataPath() {
        return this.dataPath;
    }

    @JsonProperty(value="dataPath")
    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public ContainerMetadataEntry withDataPath(String dataPath) {
        this.dataPath = dataPath;
        return this;
    }

    @JsonProperty(value="structureFormat")
    public String getStructureFormat() {
        return this.structureFormat;
    }

    @JsonProperty(value="structureFormat")
    public void setStructureFormat(String structureFormat) {
        this.structureFormat = structureFormat;
    }

    public ContainerMetadataEntry withStructureFormat(String structureFormat) {
        this.structureFormat = structureFormat;
        return this;
    }

    @JsonProperty(value="isPartitioned")
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @JsonProperty(value="isPartitioned")
    public void setIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    public ContainerMetadataEntry withIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
        return this;
    }

    @JsonProperty(value="partitionColumn")
    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    @JsonProperty(value="partitionColumn")
    public void setPartitionColumn(String partitionColumn) {
        this.partitionColumn = partitionColumn;
    }

    public ContainerMetadataEntry withPartitionColumn(String partitionColumn) {
        this.partitionColumn = partitionColumn;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ContainerMetadataEntry withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ContainerMetadataEntry.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataPath");
        sb.append('=');
        sb.append(this.dataPath == null ? "<null>" : this.dataPath);
        sb.append(',');
        sb.append("structureFormat");
        sb.append('=');
        sb.append(this.structureFormat == null ? "<null>" : this.structureFormat);
        sb.append(',');
        sb.append("isPartitioned");
        sb.append('=');
        sb.append(this.isPartitioned == null ? "<null>" : this.isPartitioned);
        sb.append(',');
        sb.append("partitionColumn");
        sb.append('=');
        sb.append(this.partitionColumn == null ? "<null>" : this.partitionColumn);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.partitionColumn == null ? 0 : this.partitionColumn.hashCode());
        result = result * 31 + (this.structureFormat == null ? 0 : this.structureFormat.hashCode());
        result = result * 31 + (this.isPartitioned == null ? 0 : this.isPartitioned.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.dataPath == null ? 0 : this.dataPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ContainerMetadataEntry)) {
            return false;
        }
        ContainerMetadataEntry rhs = (ContainerMetadataEntry)other;
        return (this.partitionColumn == rhs.partitionColumn || this.partitionColumn != null && this.partitionColumn.equals(rhs.partitionColumn)) && (this.structureFormat == rhs.structureFormat || this.structureFormat != null && this.structureFormat.equals(rhs.structureFormat)) && (this.isPartitioned == rhs.isPartitioned || this.isPartitioned != null && this.isPartitioned.equals(rhs.isPartitioned)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.dataPath == rhs.dataPath || this.dataPath != null && this.dataPath.equals(rhs.dataPath));
    }
}

